/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.model.ListClusterPropertiesResponse;
import org.apache.solr.client.api.model.SetClusterPropertyRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for clusterProperties, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class ClusterPropertiesApi {

  public static class CreateOrUpdateClusterPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateOrUpdateClusterPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateOrUpdateClusterProperty
      extends SolrRequest<CreateOrUpdateClusterPropertyResponse> {
    private final SetClusterPropertyRequestBody requestBody;
    private final String propertyName;

    /**
     * Create a CreateOrUpdateClusterProperty request object.
     *
     * @param propertyName Path param - The name of the property being set.
     */
    public CreateOrUpdateClusterProperty(String propertyName) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/cluster/properties/{propertyName}".replace("{" + "propertyName" + "}", propertyName));

      this.propertyName = propertyName;
      this.requestBody = new SetClusterPropertyRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param value The value to assign to the property.
     */
    public void setValue(String value) {
      this.requestBody.value = value;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected CreateOrUpdateClusterPropertyResponse createResponse(SolrClient client) {
      return new CreateOrUpdateClusterPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class CreateOrUpdateNestedClusterPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateOrUpdateNestedClusterPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateOrUpdateNestedClusterProperty
      extends SolrRequest<CreateOrUpdateNestedClusterPropertyResponse> {
    private final Map<String, Object> requestBody;

    /** Create a CreateOrUpdateNestedClusterProperty request object. */
    public CreateOrUpdateNestedClusterProperty() {
      super(SolrRequest.METHOD.valueOf("PUT"), "/cluster/properties");

      this.requestBody = new HashMap<>();
      addHeader("Content-type", "application/json");
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected CreateOrUpdateNestedClusterPropertyResponse createResponse(SolrClient client) {
      return new CreateOrUpdateNestedClusterPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteClusterPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteClusterPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteClusterProperty extends SolrRequest<DeleteClusterPropertyResponse> {
    private final String propertyName;

    /**
     * Create a DeleteClusterProperty request object.
     *
     * @param propertyName Path param - The name of the property being deleted.
     */
    public DeleteClusterProperty(String propertyName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/cluster/properties/{propertyName}".replace("{" + "propertyName" + "}", propertyName));

      this.propertyName = propertyName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected DeleteClusterPropertyResponse createResponse(SolrClient client) {
      return new DeleteClusterPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetClusterPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public GetClusterPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class GetClusterProperty extends SolrRequest<GetClusterPropertyResponse> {
    private final String propertyName;

    /**
     * Create a GetClusterProperty request object.
     *
     * @param propertyName Path param - The name of the property being retrieved.
     */
    public GetClusterProperty(String propertyName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cluster/properties/{propertyName}".replace("{" + "propertyName" + "}", propertyName));

      this.propertyName = propertyName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetClusterPropertyResponse createResponse(SolrClient client) {
      return new GetClusterPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListClusterPropertiesResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.ListClusterPropertiesResponse> {
    public ListClusterPropertiesResponse() {
      super(org.apache.solr.client.api.model.ListClusterPropertiesResponse.class);
    }
  }

  public static class ListClusterProperties extends SolrRequest<ListClusterPropertiesResponse> {

    /** Create a ListClusterProperties request object. */
    public ListClusterProperties() {
      super(SolrRequest.METHOD.valueOf("GET"), "/cluster/properties");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListClusterPropertiesResponse createResponse(SolrClient client) {
      return new ListClusterPropertiesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
