/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.Map;
import org.apache.solr.client.api.model.GetAliasPropertyResponse;
import org.apache.solr.client.api.model.GetAllAliasPropertiesResponse;
import org.apache.solr.client.api.model.UpdateAliasPropertiesRequestBody;
import org.apache.solr.client.api.model.UpdateAliasPropertyRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for aliasProperties, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class AliasPropertiesApi {

  public static class CreateOrUpdateAliasPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateOrUpdateAliasPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateOrUpdateAliasProperty
      extends SolrRequest<CreateOrUpdateAliasPropertyResponse> {
    private final UpdateAliasPropertyRequestBody requestBody;
    private final String aliasName;
    private final String propName;

    /**
     * Create a CreateOrUpdateAliasProperty request object.
     *
     * @param aliasName Path param - Alias Name
     * @param propName Path param - Property Name
     */
    public CreateOrUpdateAliasProperty(String aliasName, String propName) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/aliases/{aliasName}/properties/{propName}"
              .replace("{" + "aliasName" + "}", aliasName)
              .replace("{" + "propName" + "}", propName));

      this.aliasName = aliasName;
      this.propName = propName;
      this.requestBody = new UpdateAliasPropertyRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setValue(Object value) {
      this.requestBody.value = value;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected CreateOrUpdateAliasPropertyResponse createResponse(SolrClient client) {
      return new CreateOrUpdateAliasPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteAliasPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteAliasPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteAliasProperty extends SolrRequest<DeleteAliasPropertyResponse> {
    private final String aliasName;
    private final String propName;

    /**
     * Create a DeleteAliasProperty request object.
     *
     * @param aliasName Path param - Alias Name
     * @param propName Path param - Property Name
     */
    public DeleteAliasProperty(String aliasName, String propName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/aliases/{aliasName}/properties/{propName}"
              .replace("{" + "aliasName" + "}", aliasName)
              .replace("{" + "propName" + "}", propName));

      this.aliasName = aliasName;
      this.propName = propName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected DeleteAliasPropertyResponse createResponse(SolrClient client) {
      return new DeleteAliasPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAliasPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAliasPropertyResponse> {
    public GetAliasPropertyResponse() {
      super(org.apache.solr.client.api.model.GetAliasPropertyResponse.class);
    }
  }

  public static class GetAliasProperty extends SolrRequest<GetAliasPropertyResponse> {
    private final String aliasName;
    private final String propName;

    /**
     * Create a GetAliasProperty request object.
     *
     * @param aliasName Path param - Alias Name
     * @param propName Path param - Property Name
     */
    public GetAliasProperty(String aliasName, String propName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/aliases/{aliasName}/properties/{propName}"
              .replace("{" + "aliasName" + "}", aliasName)
              .replace("{" + "propName" + "}", propName));

      this.aliasName = aliasName;
      this.propName = propName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetAliasPropertyResponse createResponse(SolrClient client) {
      return new GetAliasPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAllAliasPropertiesResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.GetAllAliasPropertiesResponse> {
    public GetAllAliasPropertiesResponse() {
      super(org.apache.solr.client.api.model.GetAllAliasPropertiesResponse.class);
    }
  }

  public static class GetAllAliasProperties extends SolrRequest<GetAllAliasPropertiesResponse> {
    private final String aliasName;

    /**
     * Create a GetAllAliasProperties request object.
     *
     * @param aliasName Path param - Alias Name
     */
    public GetAllAliasProperties(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/aliases/{aliasName}/properties".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetAllAliasPropertiesResponse createResponse(SolrClient client) {
      return new GetAllAliasPropertiesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class UpdateAliasPropertiesResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public UpdateAliasPropertiesResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class UpdateAliasProperties extends SolrRequest<UpdateAliasPropertiesResponse> {
    private final UpdateAliasPropertiesRequestBody requestBody;
    private final String aliasName;

    /**
     * Create a UpdateAliasProperties request object.
     *
     * @param aliasName Path param - Alias Name
     */
    public UpdateAliasProperties(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/aliases/{aliasName}/properties".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
      this.requestBody = new UpdateAliasPropertiesRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param properties Properties and values to be updated on alias.
     */
    public void setProperties(Map<String, Object> properties) {
      this.requestBody.properties = properties;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected UpdateAliasPropertiesResponse createResponse(SolrClient client) {
      return new UpdateAliasPropertiesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
