/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateTransformer
extends Transformer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, List<String>> templateVsVars = new HashMap<String, List<String>>();
    public static final String TEMPLATE = "template";

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        VariableResolver resolver = context.getVariableResolver();
        for (Map<String, String> map : context.getAllEntityFields()) {
            map.entrySet();
            String expr = map.get(TEMPLATE);
            if (expr == null) continue;
            String column = map.get("column");
            boolean resolvable = true;
            List<String> variables = this.templateVsVars.get(expr);
            if (variables == null) {
                variables = resolver.getVariables(expr);
                this.templateVsVars.put(expr, variables);
            }
            for (String v : variables) {
                if (resolver.resolve(v) != null) continue;
                log.warn("Unable to resolve variable: " + v + " while parsing expression: " + expr);
                resolvable = false;
            }
            if (!resolvable) continue;
            if (variables.size() == 1 && expr.startsWith("${") && expr.endsWith("}")) {
                this.addToRow(column, row, resolver.resolve(variables.get(0)));
                continue;
            }
            this.addToRow(column, row, resolver.replaceTokens(expr));
        }
        return row;
    }

    private void addToRow(String key, Map<String, Object> row, Object value) {
        Object prevVal = row.get(key);
        if (prevVal != null) {
            if (prevVal instanceof List) {
                ((List)prevVal).add(value);
            } else {
                ArrayList<Object> valList = new ArrayList<Object>();
                valList.add(prevVal);
                valList.add(value);
                row.put(key, valList);
            }
        } else {
            row.put(key, value);
        }
    }
}

