/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.dataimport.DIHProperties;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePropertiesWriter
extends DIHProperties {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String LAST_INDEX_KEY = "last_index_time";
    protected String filename = null;
    protected String configDir = null;
    protected Locale locale = null;
    protected SimpleDateFormat dateFormat = null;
    public static final String LOCALE = "locale";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String DIRECTORY = "directory";
    public static final String FILENAME = "filename";

    @Override
    public void init(DataImporter dataImporter, Map<String, String> params) {
        this.filename = params.get(FILENAME) != null ? params.get(FILENAME) : (dataImporter.getHandlerName() != null ? dataImporter.getHandlerName() + ".properties" : "dataimport.properties");
        this.findDirectory(dataImporter, params);
        this.locale = params.get(LOCALE) != null ? this.getLocale(params.get(LOCALE)) : Locale.ROOT;
        this.dateFormat = params.get(DATE_FORMAT) != null ? new SimpleDateFormat(params.get(DATE_FORMAT), this.locale) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.locale);
    }

    @SuppressForbidden(reason="Usage of outdated locale parsing with Locale#toString() because of backwards compatibility")
    private Locale getLocale(String name) {
        if (name == null) {
            return Locale.ROOT;
        }
        for (Locale l : Locale.getAvailableLocales()) {
            if (!name.equals(l.toString()) && !name.equals(l.getDisplayName(Locale.ROOT))) continue;
            return this.locale;
        }
        try {
            return new Locale.Builder().setLanguageTag(name).build();
        }
        catch (IllformedLocaleException ex) {
            throw new DataImportHandlerException(500, "Unsupported locale for PropertyWriter: " + name);
        }
    }

    protected void findDirectory(DataImporter dataImporter, Map<String, String> params) {
        SolrCore core;
        this.configDir = params.get(DIRECTORY) != null ? params.get(DIRECTORY) : ((core = dataImporter.getCore()) == null ? SolrResourceLoader.locateSolrHome().toString() : core.getResourceLoader().getConfigDir());
    }

    private File getPersistFile() {
        File filePath = new File(this.filename).isAbsolute() || this.configDir == null ? new File(this.filename) : new File(new File(this.configDir), this.filename);
        return filePath;
    }

    @Override
    public boolean isWritable() {
        File persistFile = this.getPersistFile();
        try {
            return persistFile.exists() ? persistFile.canWrite() : persistFile.getParentFile().canWrite();
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    @Override
    public String convertDateToString(Date d) {
        return this.dateFormat.format(d);
    }

    protected Date convertStringToDate(String s) {
        try {
            return this.dateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new DataImportHandlerException(500, "Value for last_index_time is invalid for date format " + this.dateFormat.toLocalizedPattern() + " : " + s);
        }
    }

    protected Properties mapToProperties(Map<String, Object> propObjs) {
        Properties p = new Properties();
        for (Map.Entry<String, Object> entry : propObjs.entrySet()) {
            String key = entry.getKey();
            String val = null;
            String lastKeyPart = key;
            int lastDotPos = key.lastIndexOf(46);
            if (lastDotPos != -1 && key.length() > lastDotPos + 1) {
                lastKeyPart = key.substring(lastDotPos + 1);
            }
            val = LAST_INDEX_KEY.equals(lastKeyPart) && entry.getValue() instanceof Date ? this.convertDateToString((Date)entry.getValue()) : entry.getValue().toString();
            p.put(key, val);
        }
        return p;
    }

    protected Map<String, Object> propertiesToMap(Properties p) {
        HashMap<String, Object> theMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            theMap.put(key, val);
        }
        return theMap;
    }

    @Override
    public void persist(Map<String, Object> propObjs) {
        OutputStreamWriter propOutput = null;
        Properties existingProps = this.mapToProperties(this.readIndexerProperties());
        Properties newProps = this.mapToProperties(propObjs);
        try {
            existingProps.putAll((Map<?, ?>)newProps);
            propOutput = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getPersistFile()), StandardCharsets.UTF_8);
            existingProps.store(propOutput, null);
            log.info("Wrote last indexed time to " + this.filename);
        }
        catch (Exception e) {
            try {
                throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{propOutput});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{propOutput});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> readIndexerProperties() {
        Properties props = new Properties();
        FileInputStream propInput = null;
        try {
            String filePath = this.configDir;
            if (this.configDir != null && !this.configDir.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            filePath = filePath + this.filename;
            propInput = new FileInputStream(filePath);
            props.load(new InputStreamReader((InputStream)propInput, StandardCharsets.UTF_8));
            log.info("Read " + this.filename);
        }
        catch (Exception e) {
            try {
                log.warn("Unable to read: " + this.filename);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{propInput});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{propInput});
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{propInput});
        return this.propertiesToMap(props);
    }
}

