/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOLR_SERVER = "url";
    public static final String QUERY = "query";
    public static final String TIMEOUT = "timeout";
    public static final int TIMEOUT_SECS = 300;
    public static final int ROWS_DEFAULT = 50;
    private SolrClient solrClient = null;
    private String queryString;
    private int rows = 50;
    private String[] filterQueries;
    private String[] fields;
    private String requestHandler;
    private int timeout = 300;

    @Override
    public void destroy() {
        try {
            this.solrClient.close();
        }
        catch (IOException iOException) {
        }
        finally {
            HttpClientUtil.close((HttpClient)((HttpSolrClient)this.solrClient).getHttpClient());
        }
    }

    protected HttpClient getHttpClient() {
        return HttpClientUtil.createClient(null);
    }

    @Override
    protected void firstInit(Context context) {
        super.firstInit(context);
        try {
            String serverPath = context.getResolvedEntityAttribute(SOLR_SERVER);
            if (serverPath == null) {
                throw new DataImportHandlerException(500, "SolrEntityProcessor: parameter 'url' is required");
            }
            HttpClient client = this.getHttpClient();
            URL url = new URL(serverPath);
            if ("xml".equals(context.getResolvedEntityAttribute("wt"))) {
                this.solrClient = new HttpSolrClient.Builder(url.toExternalForm()).withHttpClient(client).withResponseParser((ResponseParser)new XMLResponseParser()).build();
                LOG.info("using XMLResponseParser");
            } else {
                this.solrClient = new HttpSolrClient.Builder(url.toExternalForm()).withHttpClient(client).build();
                LOG.info("using BinaryResponseParser");
            }
        }
        catch (MalformedURLException e) {
            throw new DataImportHandlerException(500, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        this.buildIterator();
        return this.getNext();
    }

    private void buildIterator() {
        if (this.rowIterator != null) {
            SolrDocumentList solrDocumentList;
            SolrDocumentListIterator documentListIterator = (SolrDocumentListIterator)this.rowIterator;
            if (!documentListIterator.hasNext() && documentListIterator.hasMoreRows() && (solrDocumentList = this.doQuery(documentListIterator.getStart() + documentListIterator.getSize())) != null) {
                this.rowIterator = new SolrDocumentListIterator(solrDocumentList);
            }
        } else {
            SolrDocumentList solrDocumentList = this.doQuery(0);
            if (solrDocumentList != null) {
                this.rowIterator = new SolrDocumentListIterator(solrDocumentList);
            }
            return;
        }
    }

    protected SolrDocumentList doQuery(int start) {
        QueryResponse response;
        block10: {
            String fieldsAsString;
            String fqAsString;
            this.queryString = this.context.getResolvedEntityAttribute(QUERY);
            if (this.queryString == null) {
                throw new DataImportHandlerException(500, "SolrEntityProcessor: parameter 'query' is required");
            }
            String rowsP = this.context.getResolvedEntityAttribute("rows");
            if (rowsP != null) {
                this.rows = Integer.parseInt(rowsP);
            }
            if ((fqAsString = this.context.getResolvedEntityAttribute("fq")) != null) {
                this.filterQueries = fqAsString.split(",");
            }
            if ((fieldsAsString = this.context.getResolvedEntityAttribute("fl")) != null) {
                this.fields = fieldsAsString.split(",");
            }
            this.requestHandler = this.context.getResolvedEntityAttribute("qt");
            String timeoutAsString = this.context.getResolvedEntityAttribute(TIMEOUT);
            if (timeoutAsString != null) {
                this.timeout = Integer.parseInt(timeoutAsString);
            }
            SolrQuery solrQuery = new SolrQuery(this.queryString);
            solrQuery.setRows(Integer.valueOf(this.rows));
            solrQuery.setStart(Integer.valueOf(start));
            if (this.fields != null) {
                for (String field : this.fields) {
                    solrQuery.addField(field);
                }
            }
            solrQuery.setRequestHandler(this.requestHandler);
            solrQuery.setFilterQueries(this.filterQueries);
            solrQuery.setTimeAllowed(Integer.valueOf(this.timeout * 1000));
            response = null;
            try {
                response = this.solrClient.query((SolrParams)solrQuery);
            }
            catch (IOException | SolrServerException e) {
                if ("abort".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(500, (Exception)e);
                }
                if (!"skip".equals(this.onError)) break block10;
                DataImportHandlerException.wrapAndThrow(301, (Exception)e);
            }
        }
        return response == null ? null : response.getResults();
    }

    private static class SolrDocumentListIterator
    implements Iterator<Map<String, Object>> {
        private final int start;
        private final int size;
        private final long numFound;
        private final Iterator<SolrDocument> solrDocumentIterator;

        public SolrDocumentListIterator(SolrDocumentList solrDocumentList) {
            this.solrDocumentIterator = solrDocumentList.iterator();
            this.numFound = solrDocumentList.getNumFound();
            this.start = (int)solrDocumentList.getStart();
            this.size = solrDocumentList.size();
        }

        @Override
        public boolean hasNext() {
            return this.solrDocumentIterator.hasNext();
        }

        @Override
        public Map<String, Object> next() {
            SolrDocument solrDocument = this.solrDocumentIterator.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Collection fields = solrDocument.getFieldNames();
            for (String field : fields) {
                Object fieldValue = solrDocument.getFieldValue(field);
                map.put(field, fieldValue);
            }
            return map;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }

        public boolean hasMoreRows() {
            return this.numFound > (long)(this.start + this.size);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

