/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DIHLogLevels;
import org.apache.solr.handler.dataimport.DIHProperties;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.EventListener;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Date EPOCH = new Date(0L);
    public static final String DELETE_DOC_BY_ID = "$deleteDocById";
    public static final String DELETE_DOC_BY_QUERY = "$deleteDocByQuery";
    public static final String DOC_BOOST = "$docBoost";
    public static final String SKIP_DOC = "$skipDoc";
    public static final String SKIP_ROW = "$skipRow";
    DataImporter dataImporter;
    private DIHConfiguration config;
    private EntityProcessorWrapper currentEntityProcessorWrapper;
    private Map statusMessages = Collections.synchronizedMap(new LinkedHashMap());
    public Statistics importStatistics = new Statistics();
    DIHWriter writer;
    boolean verboseDebug = false;
    Map<String, Object> session = new HashMap<String, Object>();
    static final ThreadLocal<DocBuilder> INSTANCE = new ThreadLocal();
    private Map<String, Object> persistedProperties;
    private DIHProperties propWriter;
    private DebugLogger debugLogger;
    private final RequestInfo reqParams;
    private AtomicBoolean stop = new AtomicBoolean(false);
    public static final String TIME_ELAPSED = "Time Elapsed";
    public static final String LAST_INDEX_TIME = "last_index_time";
    public static final String INDEX_START_TIME = "index_start_time";

    public DocBuilder(DataImporter dataImporter, DIHWriter solrWriter, DIHProperties propWriter, RequestInfo reqParams) {
        INSTANCE.set(this);
        this.dataImporter = dataImporter;
        this.reqParams = reqParams;
        this.propWriter = propWriter;
        DataImporter.QUERY_COUNT.set(this.importStatistics.queryCount);
        this.verboseDebug = reqParams.isDebug() && reqParams.getDebugInfo().verbose;
        this.persistedProperties = propWriter.readIndexerProperties();
        this.writer = solrWriter;
        ContextImpl ctx = new ContextImpl(null, null, null, null, reqParams.getRawParams(), null, this);
        if (this.writer != null) {
            this.writer.init(ctx);
        }
    }

    DebugLogger getDebugLogger() {
        if (this.debugLogger == null) {
            this.debugLogger = new DebugLogger();
        }
        return this.debugLogger;
    }

    private VariableResolver getVariableResolver() {
        try {
            VariableResolver resolver = null;
            String epoch = this.propWriter.convertDateToString(EPOCH);
            resolver = this.dataImporter != null && this.dataImporter.getCore() != null && this.dataImporter.getCore().getResourceLoader().getCoreProperties() != null ? new VariableResolver(this.dataImporter.getCore().getResourceLoader().getCoreProperties()) : new VariableResolver();
            resolver.setEvaluators(this.dataImporter.getEvaluators());
            HashMap<String, Object> indexerNamespace = new HashMap<String, Object>();
            if (this.persistedProperties.get(LAST_INDEX_TIME) != null) {
                indexerNamespace.put(LAST_INDEX_TIME, this.persistedProperties.get(LAST_INDEX_TIME));
            } else {
                indexerNamespace.put(LAST_INDEX_TIME, epoch);
            }
            indexerNamespace.put(INDEX_START_TIME, this.dataImporter.getIndexStartTime());
            indexerNamespace.put("request", new HashMap<String, Object>(this.reqParams.getRawParams()));
            indexerNamespace.put("handlerName", this.dataImporter.getHandlerName());
            for (Entity entity : this.dataImporter.getConfig().getEntities()) {
                HashMap<String, Object> entityNamespace = new HashMap<String, Object>();
                String key = LAST_INDEX_TIME;
                Object lastIndex = this.persistedProperties.get(entity.getName() + "." + key);
                if (lastIndex != null) {
                    entityNamespace.put(LAST_INDEX_TIME, lastIndex);
                } else {
                    entityNamespace.put(LAST_INDEX_TIME, epoch);
                }
                indexerNamespace.put(entity.getName(), entityNamespace);
            }
            resolver.addNamespace("dih", indexerNamespace);
            resolver.addNamespace("dataimporter", indexerNamespace);
            return resolver;
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e);
            return null;
        }
    }

    private void invokeEventListener(String className) {
        this.invokeEventListener(className, null);
    }

    private void invokeEventListener(String className, Exception lastException) {
        try {
            EventListener listener = (EventListener)DocBuilder.loadClass(className, this.dataImporter.getCore()).newInstance();
            this.notifyListener(listener, lastException);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to load class : " + className);
        }
    }

    private void notifyListener(EventListener listener, Exception lastException) {
        String currentProcess = this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP ? "DELTA_DUMP" : "FULL_DUMP";
        ContextImpl ctx = new ContextImpl(null, this.getVariableResolver(), null, currentProcess, this.session, null, this);
        ctx.setLastException(lastException);
        listener.onEvent(ctx);
    }

    public void execute() {
        ArrayList<EntityProcessorWrapper> epwList = null;
        try {
            this.dataImporter.store("status-messages", this.statusMessages);
            this.config = this.dataImporter.getConfig();
            final AtomicLong startTime = new AtomicLong(System.nanoTime());
            this.statusMessages.put(TIME_ELAPSED, new Object(){

                public String toString() {
                    return DocBuilder.getTimeElapsedSince(startTime.get());
                }
            });
            this.statusMessages.put("Total Requests made to DataSource", this.importStatistics.queryCount);
            this.statusMessages.put("Total Rows Fetched", this.importStatistics.rowsCount);
            this.statusMessages.put("Total Documents Processed", this.importStatistics.docCount);
            this.statusMessages.put("Total Documents Skipped", this.importStatistics.skipDocCount);
            List<String> entities = this.reqParams.getEntitiesToRun();
            if (this.config.getOnImportStart() != null) {
                this.invokeEventListener(this.config.getOnImportStart());
            }
            AtomicBoolean fullCleanDone = new AtomicBoolean(false);
            HashMap<String, Object> lastIndexTimeProps = new HashMap<String, Object>();
            lastIndexTimeProps.put(LAST_INDEX_TIME, this.dataImporter.getIndexStartTime());
            epwList = new ArrayList<EntityProcessorWrapper>(this.config.getEntities().size());
            for (Entity e : this.config.getEntities()) {
                epwList.add(this.getEntityProcessorWrapper(e));
            }
            for (EntityProcessorWrapper epw : epwList) {
                if (entities != null && !entities.contains(epw.getEntity().getName())) continue;
                lastIndexTimeProps.put(epw.getEntity().getName() + "." + LAST_INDEX_TIME, this.propWriter.getCurrentTimestamp());
                this.currentEntityProcessorWrapper = epw;
                String delQuery = epw.getEntity().getAllAttributes().get("preImportDeleteQuery");
                if (this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP) {
                    this.cleanByQuery(delQuery, fullCleanDone);
                    this.doDelta();
                    delQuery = epw.getEntity().getAllAttributes().get("postImportDeleteQuery");
                    if (delQuery == null) continue;
                    fullCleanDone.set(false);
                    this.cleanByQuery(delQuery, fullCleanDone);
                    continue;
                }
                this.cleanByQuery(delQuery, fullCleanDone);
                this.doFullDump();
                delQuery = epw.getEntity().getAllAttributes().get("postImportDeleteQuery");
                if (delQuery == null) continue;
                fullCleanDone.set(false);
                this.cleanByQuery(delQuery, fullCleanDone);
            }
            if (this.stop.get()) {
                this.statusMessages.put("Aborted", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT).format(new Date()));
                this.handleError("Aborted", null);
            } else {
                if (!this.reqParams.isClean()) {
                    if (this.importStatistics.docCount.get() > 0L || this.importStatistics.deletedDocCount.get() > 0L) {
                        this.finish(lastIndexTimeProps);
                    }
                } else {
                    this.finish(lastIndexTimeProps);
                }
                if (this.config.getOnImportEnd() != null) {
                    this.invokeEventListener(this.config.getOnImportEnd());
                }
            }
            this.statusMessages.remove(TIME_ELAPSED);
            this.statusMessages.put("Total Documents Processed", "" + this.importStatistics.docCount.get());
            if (this.importStatistics.failedDocCount.get() > 0L) {
                this.statusMessages.put("Total Documents Failed", "" + this.importStatistics.failedDocCount.get());
            }
            this.statusMessages.put("Time taken", DocBuilder.getTimeElapsedSince(startTime.get()));
            LOG.info("Time taken = " + DocBuilder.getTimeElapsedSince(startTime.get()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
            if (epwList != null) {
                this.closeEntityProcessorWrappers(epwList);
            }
            if (this.reqParams.isDebug()) {
                this.reqParams.getDebugInfo().debugVerboseOutput = this.getDebugLogger().output;
            }
        }
    }

    private void closeEntityProcessorWrappers(List<EntityProcessorWrapper> epwList) {
        for (EntityProcessorWrapper epw : epwList) {
            epw.close();
            if (epw.getDatasource() != null) {
                epw.getDatasource().close();
            }
            this.closeEntityProcessorWrappers(epw.getChildren());
        }
    }

    private void finish(Map<String, Object> lastIndexTimeProps) {
        LOG.info("Import completed successfully");
        this.statusMessages.put("", "Indexing completed. Added/Updated: " + this.importStatistics.docCount + " documents. Deleted " + this.importStatistics.deletedDocCount + " documents.");
        if (this.reqParams.isCommit()) {
            this.writer.commit(this.reqParams.isOptimize());
            this.addStatusMessage("Committed");
            if (this.reqParams.isOptimize()) {
                this.addStatusMessage("Optimized");
            }
        }
        try {
            this.propWriter.persist(lastIndexTimeProps);
        }
        catch (Exception e) {
            LOG.error("Could not write property file", (Throwable)e);
            this.statusMessages.put("error", "Could not write property file. Delta imports will not work. Make sure your conf directory is writable");
        }
    }

    void handleError(String message, Exception e) {
        if (!this.dataImporter.getCore().getCoreDescriptor().getCoreContainer().isZooKeeperAware()) {
            this.writer.rollback();
        }
        this.statusMessages.put(message, "Indexing error");
        this.addStatusMessage(message);
        if (this.config != null && this.config.getOnError() != null) {
            this.invokeEventListener(this.config.getOnError(), e);
        }
    }

    private void doFullDump() {
        this.addStatusMessage("Full Dump Started");
        this.buildDocument(this.getVariableResolver(), null, null, this.currentEntityProcessorWrapper, true, null);
    }

    private void doDelta() {
        this.addStatusMessage("Delta Dump started");
        VariableResolver resolver = this.getVariableResolver();
        if (this.config.getDeleteQuery() != null) {
            this.writer.deleteByQuery(this.config.getDeleteQuery());
        }
        this.addStatusMessage("Identifying Delta");
        LOG.info("Starting delta collection.");
        HashSet<Map<String, Object>> deletedKeys = new HashSet<Map<String, Object>>();
        Set<Map<String, Object>> allPks = this.collectDelta(this.currentEntityProcessorWrapper, resolver, deletedKeys);
        if (this.stop.get()) {
            return;
        }
        this.addStatusMessage("Deltas Obtained");
        this.addStatusMessage("Building documents");
        if (!deletedKeys.isEmpty()) {
            allPks.removeAll(deletedKeys);
            this.deleteAll(deletedKeys);
        }
        deletedKeys = null;
        this.writer.setDeltaKeys(allPks);
        this.statusMessages.put("Total Changed Documents", allPks.size());
        VariableResolver vri = this.getVariableResolver();
        Iterator<Map<String, Object>> pkIter = allPks.iterator();
        while (pkIter.hasNext()) {
            Map<String, Object> map = pkIter.next();
            vri.addNamespace("dih.delta", map);
            this.buildDocument(vri, null, map, this.currentEntityProcessorWrapper, true, null);
            pkIter.remove();
            if (!this.stop.get()) continue;
            break;
        }
        if (!this.stop.get()) {
            LOG.info("Delta Import completed successfully");
        }
    }

    private void deleteAll(Set<Map<String, Object>> deletedKeys) {
        LOG.info("Deleting stale documents ");
        Iterator<Map<String, Object>> iter = deletedKeys.iterator();
        while (iter.hasNext()) {
            String keyName;
            Map<String, Object> map = iter.next();
            Object key = map.get(keyName = this.currentEntityProcessorWrapper.getEntity().isDocRoot() ? this.currentEntityProcessorWrapper.getEntity().getPk() : this.currentEntityProcessorWrapper.getEntity().getSchemaPk());
            if (key == null) {
                keyName = this.findMatchingPkColumn(keyName, map);
                key = map.get(keyName);
            }
            if (key == null) {
                LOG.warn("no key was available for deleted pk query. keyName = " + keyName);
                continue;
            }
            this.writer.deleteDoc(key);
            this.importStatistics.deletedDocCount.incrementAndGet();
            iter.remove();
        }
    }

    public void addStatusMessage(String msg) {
        this.statusMessages.put(msg, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT).format(new Date()));
    }

    private void resetEntity(EntityProcessorWrapper epw) {
        epw.setInitialized(false);
        for (EntityProcessorWrapper child : epw.getChildren()) {
            this.resetEntity(child);
        }
    }

    private void buildDocument(VariableResolver vr, DocWrapper doc, Map<String, Object> pk, EntityProcessorWrapper epw, boolean isRoot, ContextImpl parentCtx) {
        ArrayList<EntityProcessorWrapper> entitiesToDestroy = new ArrayList<EntityProcessorWrapper>();
        try {
            this.buildDocument(vr, doc, pk, epw, isRoot, parentCtx, entitiesToDestroy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            for (EntityProcessorWrapper entityWrapper : entitiesToDestroy) {
                entityWrapper.destroy();
            }
            this.resetEntity(epw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildDocument(VariableResolver vr, DocWrapper doc, Map<String, Object> pk, EntityProcessorWrapper epw, boolean isRoot, ContextImpl parentCtx, List<EntityProcessorWrapper> entitiesToDestroy) {
        block45: {
            ctx = new ContextImpl(epw, vr, null, pk == null ? "FULL_DUMP" : "DELTA_DUMP", this.session, parentCtx, this);
            epw.init(ctx);
            if (!epw.isInitialized()) {
                entitiesToDestroy.add(epw);
                epw.setInitialized(true);
            }
            if (this.reqParams.getStart() > 0) {
                this.getDebugLogger().log(DIHLogLevels.DISABLE_LOGGING, null, null);
            }
            if (this.verboseDebug) {
                this.getDebugLogger().log(DIHLogLevels.START_ENTITY, epw.getEntity().getName(), null);
            }
            seenDocCount = 0;
            while (true) lbl-1000:
            // 9 sources

            {
                if (this.stop.get()) {
                    return;
                }
                if (this.importStatistics.docCount.get() > (long)this.reqParams.getStart() + this.reqParams.getRows()) {
                    break block45;
                }
                try {
                    if (++seenDocCount > this.reqParams.getStart()) {
                        this.getDebugLogger().log(DIHLogLevels.ENABLE_LOGGING, null, null);
                    }
                    if (this.verboseDebug && epw.getEntity().isDocRoot()) {
                        this.getDebugLogger().log(DIHLogLevels.START_DOC, epw.getEntity().getName(), null);
                    }
                    if (doc == null && epw.getEntity().isDocRoot()) {
                        doc = new DocWrapper();
                        ctx.setDoc(doc);
                        e = epw.getEntity();
                        while (e.getParentEntity() != null) {
                            this.addFields(e.getParentEntity(), doc, (Map)vr.resolve(e.getParentEntity().getName()), vr);
                            e = e.getParentEntity();
                        }
                    }
                    if ((arow = epw.nextRow()) == null) break block45;
                    if (epw.getEntity().isDocRoot()) {
                        if (seenDocCount <= this.reqParams.getStart()) ** GOTO lbl-1000
                        if ((long)seenDocCount > (long)this.reqParams.getStart() + this.reqParams.getRows()) {
                            DocBuilder.LOG.info("Indexing stopped at docCount = " + this.importStatistics.docCount);
                            break block45;
                        }
                    }
                    if (this.verboseDebug) {
                        this.getDebugLogger().log(DIHLogLevels.ENTITY_OUT, epw.getEntity().getName(), arow);
                    }
                    this.importStatistics.rowsCount.incrementAndGet();
                    childDoc = null;
                    if (doc != null) {
                        if (epw.getEntity().isChild()) {
                            childDoc = new DocWrapper();
                            this.handleSpecialCommands(arow, childDoc);
                            this.addFields(epw.getEntity(), childDoc, arow, vr);
                            doc.addChildDocument(childDoc);
                        } else {
                            this.handleSpecialCommands(arow, doc);
                            this.addFields(epw.getEntity(), doc, arow, vr);
                        }
                    }
                    if (epw.getEntity().getChildren() != null) {
                        vr.addNamespace(epw.getEntity().getName(), arow);
                        for (EntityProcessorWrapper child : epw.getChildren()) {
                            if (childDoc != null) {
                                this.buildDocument(vr, childDoc, child.getEntity().isDocRoot() != false ? pk : null, child, false, ctx, entitiesToDestroy);
                                continue;
                            }
                            this.buildDocument(vr, doc, child.getEntity().isDocRoot() != false ? pk : null, child, false, ctx, entitiesToDestroy);
                        }
                        vr.removeNamespace(epw.getEntity().getName());
                    }
                    if (!epw.getEntity().isDocRoot()) ** GOTO lbl-1000
                    if (this.stop.get()) {
                        return;
                    }
                    if (doc.isEmpty()) ** GOTO lbl-1000
                    result = this.writer.upload(doc);
                    if (this.reqParams.isDebug()) {
                        this.reqParams.getDebugInfo().debugDocuments.add(doc);
                    }
                    doc = null;
                    if (result) {
                        this.importStatistics.docCount.incrementAndGet();
                    }
                    this.importStatistics.failedDocCount.incrementAndGet();
                }
                catch (DataImportHandlerException e) {
                    if (this.verboseDebug) {
                        this.getDebugLogger().log(DIHLogLevels.ENTITY_EXCEPTION, epw.getEntity().getName(), e);
                    }
                    if (e.getErrCode() == 301) ** GOTO lbl-1000
                    if (isRoot) {
                        if (e.getErrCode() == 300) {
                            this.importStatistics.skipDocCount.getAndIncrement();
                            doc = null;
                        } else {
                            SolrException.log((Logger)DocBuilder.LOG, (String)("Exception while processing: " + epw.getEntity().getName() + " document : " + (Object)doc), (Throwable)e);
                        }
                        if (e.getErrCode() != 500) ** GOTO lbl-1000
                        throw e;
                    }
                    throw e;
                }
                catch (Exception t) {
                    if (this.verboseDebug) {
                        this.getDebugLogger().log(DIHLogLevels.ENTITY_EXCEPTION, epw.getEntity().getName(), t);
                    }
                    throw new DataImportHandlerException(500, (Throwable)t);
                }
                finally {
                    if (!this.verboseDebug) continue;
                    this.getDebugLogger().log(DIHLogLevels.ROW_END, epw.getEntity().getName(), null);
                    if (!epw.getEntity().isDocRoot()) continue;
                    this.getDebugLogger().log(DIHLogLevels.END_DOC, null, null);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.verboseDebug) {
                    this.getDebugLogger().log(DIHLogLevels.END_ENTITY, null, null);
                }
            }
        }
    }

    private void handleSpecialCommands(Map<String, Object> arow, DocWrapper doc) {
        Collection collection;
        Object value = arow.get(DELETE_DOC_BY_ID);
        if (value != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteDoc(o.toString());
                    this.importStatistics.deletedDocCount.incrementAndGet();
                }
            } else {
                this.writer.deleteDoc(value);
                this.importStatistics.deletedDocCount.incrementAndGet();
            }
        }
        if ((value = arow.get(DELETE_DOC_BY_QUERY)) != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteByQuery(o.toString());
                    this.importStatistics.deletedDocCount.incrementAndGet();
                }
            } else {
                this.writer.deleteByQuery(value.toString());
                this.importStatistics.deletedDocCount.incrementAndGet();
            }
        }
        if ((value = arow.get(DOC_BOOST)) != null) {
            float value1 = 1.0f;
            value1 = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
            doc.setDocumentBoost(value1);
        }
        if ((value = arow.get(SKIP_DOC)) != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(300, "Document skipped :" + arow);
        }
        value = arow.get(SKIP_ROW);
        if (value != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(301);
        }
    }

    private void addFields(Entity entity, DocWrapper doc, Map<String, Object> arow, VariableResolver vr) {
        for (Map.Entry<String, Object> entry : arow.entrySet()) {
            IndexSchema schema;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || key.startsWith("$")) continue;
            Set<EntityField> field = entity.getColNameVsField().get(key);
            IndexSchema indexSchema = schema = null == this.reqParams.getRequest() ? null : this.reqParams.getRequest().getSchema();
            if (field == null && schema != null) {
                SchemaField sf = schema.getFieldOrNull(key);
                if (sf == null) {
                    sf = this.config.getSchemaField(key);
                }
                if (sf == null) continue;
                this.addFieldToDoc(entry.getValue(), sf.getName(), 1.0f, sf.multiValued(), doc);
                continue;
            }
            if (field == null) continue;
            for (EntityField f : field) {
                String name = f.getName();
                boolean multiValued = f.isMultiValued();
                boolean toWrite = f.isToWrite();
                if (f.isDynamicName()) {
                    SchemaField schemaField = this.config.getSchemaField(name = vr.replaceTokens(name));
                    if (schemaField == null) {
                        toWrite = false;
                    } else {
                        multiValued = schemaField.multiValued();
                        toWrite = true;
                    }
                }
                if (!toWrite) continue;
                this.addFieldToDoc(entry.getValue(), name, f.getBoost(), multiValued, doc);
            }
        }
    }

    private void addFieldToDoc(Object value, String name, float boost, boolean multiValued, DocWrapper doc) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (multiValued) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                }
            } else if (doc.getField(name) == null) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                    break;
                }
            }
        } else if (multiValued) {
            if (value != null) {
                doc.addField(name, value, boost);
            }
        } else if (doc.getField(name) == null && value != null) {
            doc.addField(name, value, boost);
        }
    }

    public EntityProcessorWrapper getEntityProcessorWrapper(Entity entity) {
        EntityProcessor entityProcessor = null;
        if (entity.getProcessorName() == null) {
            entityProcessor = new SqlEntityProcessor();
        } else {
            try {
                entityProcessor = (EntityProcessor)DocBuilder.loadClass(entity.getProcessorName(), this.dataImporter.getCore()).newInstance();
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to load EntityProcessor implementation for entity:" + entity.getName());
            }
        }
        EntityProcessorWrapper epw = new EntityProcessorWrapper(entityProcessor, entity, this);
        for (Entity e1 : entity.getChildren()) {
            epw.getChildren().add(this.getEntityProcessorWrapper(e1));
        }
        return epw;
    }

    private String findMatchingPkColumn(String pk, Map<String, Object> row) {
        if (row.containsKey(pk)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "deltaQuery returned a row with null for primary key %s", pk));
        }
        String resolvedPk = null;
        for (String columnName : row.keySet()) {
            if (!columnName.endsWith("." + pk) && !pk.endsWith("." + columnName)) continue;
            if (resolvedPk != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "deltaQuery has more than one column (%s and %s) that might resolve to declared primary key pk='%s'", resolvedPk, columnName, pk));
            }
            resolvedPk = columnName;
        }
        if (resolvedPk == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "deltaQuery has no column to resolve to declared primary key pk='%s'", pk));
        }
        LOG.info(String.format(Locale.ROOT, "Resolving deltaQuery column '%s' to match entity's declared pk '%s'", resolvedPk, pk));
        return resolvedPk;
    }

    public Set<Map<String, Object>> collectDelta(EntityProcessorWrapper epw, VariableResolver resolver, Set<Map<String, Object>> deletedRows) {
        Map<String, Object> row;
        Map<String, Object> row2;
        if (this.stop.get()) {
            return new HashSet<Map<String, Object>>();
        }
        ContextImpl context1 = new ContextImpl(epw, resolver, null, "FIND_DELTA", this.session, null, this);
        epw.init(context1);
        HashSet<Map<String, Object>> myModifiedPks = new HashSet<Map<String, Object>>();
        for (EntityProcessorWrapper childEpw : epw.getChildren()) {
            myModifiedPks.addAll(this.collectDelta(childEpw, resolver, deletedRows));
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        HashMap<String, Map<String, Object>> deltaSet = new HashMap<String, Map<String, Object>>();
        LOG.info("Running ModifiedRowKey() for Entity: " + epw.getEntity().getName());
        String pk = epw.getEntity().getPk();
        while ((row2 = epw.nextModifiedRowKey()) != null) {
            Object pkValue = row2.get(pk);
            if (pkValue == null) {
                pk = this.findMatchingPkColumn(pk, row2);
                pkValue = row2.get(pk);
            }
            deltaSet.put(pkValue.toString(), row2);
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        HashSet<Map<String, Object>> deletedSet = new HashSet<Map<String, Object>>();
        while ((row = epw.nextDeletedRowKey()) != null) {
            String string;
            deletedSet.add(row);
            Object pkValue = row.get(pk);
            if (pkValue == null) {
                pk = this.findMatchingPkColumn(pk, row);
                pkValue = row.get(pk);
            }
            if (deltaSet.containsKey(string = pkValue.toString())) {
                deltaSet.remove(string);
            }
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        LOG.info("Completed ModifiedRowKey for Entity: " + epw.getEntity().getName() + " rows obtained : " + deltaSet.size());
        LOG.info("Completed DeletedRowKey for Entity: " + epw.getEntity().getName() + " rows obtained : " + deletedSet.size());
        myModifiedPks.addAll(deltaSet.values());
        HashSet<Map<String, Object>> parentKeyList = new HashSet<Map<String, Object>>();
        if (epw.getEntity().getParentEntity() != null) {
            for (Map map : myModifiedPks) {
                resolver.addNamespace(epw.getEntity().getName(), map);
                this.getModifiedParentRows(resolver, epw.getEntity().getName(), epw, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
            for (Map map : deletedSet) {
                resolver.addNamespace(epw.getEntity().getName(), map);
                this.getModifiedParentRows(resolver, epw.getEntity().getName(), epw, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
        }
        LOG.info("Completed parentDeltaQuery for Entity: " + epw.getEntity().getName());
        if (epw.getEntity().isDocRoot()) {
            deletedRows.addAll(deletedSet);
        }
        return epw.getEntity().getParentEntity() == null ? myModifiedPks : new HashSet<Map<String, Object>>(parentKeyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModifiedParentRows(VariableResolver resolver, String entity, EntityProcessor entityProcessor, Set<Map<String, Object>> parentKeyList) {
        try {
            Map<String, Object> parentRow;
            while ((parentRow = entityProcessor.nextModifiedParentRowKey()) != null) {
                parentKeyList.add(parentRow);
                this.importStatistics.rowsCount.incrementAndGet();
                if (!this.stop.get()) continue;
                return;
            }
        }
        finally {
            resolver.removeNamespace(entity);
        }
    }

    public void abort() {
        this.stop.set(true);
    }

    static String getTimeElapsedSince(long l) {
        l = TimeUnit.MILLISECONDS.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS);
        return l / 3600000L + ":" + l / 60000L % 60L + ":" + l / 1000L % 60L + "." + l % 1000L;
    }

    public RequestInfo getReqParams() {
        return this.reqParams;
    }

    static Class loadClass(String name, SolrCore core) throws ClassNotFoundException {
        try {
            return core != null ? core.getResourceLoader().findClass(name, Object.class) : Class.forName(name);
        }
        catch (Exception e) {
            try {
                String n = DocBuilder.class.getPackage().getName() + "." + name;
                return core != null ? core.getResourceLoader().findClass(n, Object.class) : Class.forName(n);
            }
            catch (Exception e1) {
                throw new ClassNotFoundException("Unable to load " + name + " or " + DocBuilder.class.getPackage().getName() + "." + name, e);
            }
        }
    }

    private void cleanByQuery(String delQuery, AtomicBoolean completeCleanDone) {
        delQuery = this.getVariableResolver().replaceTokens(delQuery);
        if (this.reqParams.isClean()) {
            if (delQuery == null && !completeCleanDone.get()) {
                this.writer.doDeleteAll();
                completeCleanDone.set(true);
            } else if (delQuery != null) {
                this.writer.deleteByQuery(delQuery);
            }
        }
    }

    public static class Statistics {
        public AtomicLong docCount = new AtomicLong();
        public AtomicLong deletedDocCount = new AtomicLong();
        public AtomicLong failedDocCount = new AtomicLong();
        public AtomicLong rowsCount = new AtomicLong();
        public AtomicLong queryCount = new AtomicLong();
        public AtomicLong skipDocCount = new AtomicLong();

        public Statistics add(Statistics stats) {
            this.docCount.addAndGet(stats.docCount.get());
            this.deletedDocCount.addAndGet(stats.deletedDocCount.get());
            this.rowsCount.addAndGet(stats.rowsCount.get());
            this.queryCount.addAndGet(stats.queryCount.get());
            return this;
        }

        public Map<String, Object> getStatsSnapshot() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("docCount", this.docCount.get());
            result.put("deletedDocCount", this.deletedDocCount.get());
            result.put("rowCount", this.rowsCount.get());
            result.put("queryCount", this.rowsCount.get());
            result.put("skipDocCount", this.skipDocCount.get());
            return result;
        }
    }

    static class DocWrapper
    extends SolrInputDocument {
        Map<String, Object> session;

        DocWrapper() {
            super(new String[0]);
        }

        public void setSessionAttribute(String key, Object val) {
            if (this.session == null) {
                this.session = new HashMap<String, Object>();
            }
            this.session.put(key, val);
        }

        public Object getSessionAttribute(String key) {
            return this.session == null ? null : this.session.get(key);
        }
    }
}

