/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderDataSource
extends DataSource<Reader> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected VariableResolver vr;
    protected String dataField;
    private String encoding;
    private EntityProcessorWrapper entityProcessor;

    @Override
    public void init(Context context, Properties initProps) {
        this.dataField = context.getEntityAttribute("dataField");
        this.encoding = context.getEntityAttribute("encoding");
        this.entityProcessor = (EntityProcessorWrapper)context.getEntityProcessor();
    }

    @Override
    public Reader getData(String query) {
        Object o = this.entityProcessor.getVariableResolver().resolve(this.dataField);
        if (o == null) {
            throw new DataImportHandlerException(500, "No field available for name : " + this.dataField);
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            try {
                return FieldReaderDataSource.readCharStream(clob);
            }
            catch (Exception e) {
                LOG.info("Unable to get data from CLOB");
                return null;
            }
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                return this.getReader(blob);
            }
            catch (Exception e) {
                LOG.info("Unable to get data from BLOB");
                return null;
            }
        }
        return new StringReader(o.toString());
    }

    static Reader readCharStream(Clob clob) {
        try {
            return clob.getCharacterStream();
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to get reader from clob");
            return null;
        }
    }

    private Reader getReader(Blob blob) throws SQLException, UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(blob.getBinaryStream(), StandardCharsets.UTF_8);
        }
        return new InputStreamReader(blob.getBinaryStream(), this.encoding);
    }

    @Override
    public void close() {
    }
}

