/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatTransformer
extends Transformer {
    private Map<String, SimpleDateFormat> fmtCache = new HashMap<String, SimpleDateFormat>();
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DATE_TIME_FMT = "dateTimeFormat";

    @Override
    public Object transformRow(Map<String, Object> aRow, Context context) {
        for (Map<String, String> map : context.getAllEntityFields()) {
            String fmt;
            Locale locale = Locale.ROOT;
            String customLocale = map.get("locale");
            if (customLocale != null) {
                locale = new Locale(customLocale);
            }
            if ((fmt = map.get(DATE_TIME_FMT)) == null) continue;
            VariableResolver resolver = context.getVariableResolver();
            fmt = resolver.replaceTokens(fmt);
            String column = map.get("column");
            String srcCol = map.get("sourceColName");
            if (srcCol == null) {
                srcCol = column;
            }
            try {
                Object o = aRow.get(srcCol);
                if (o instanceof List) {
                    List inputs = (List)o;
                    ArrayList<Date> results = new ArrayList<Date>();
                    for (Object input : inputs) {
                        results.add(this.process(input, fmt, locale));
                    }
                    aRow.put(column, results);
                    continue;
                }
                if (o == null) continue;
                aRow.put(column, this.process(o, fmt, locale));
            }
            catch (ParseException e) {
                LOG.warn("Could not parse a Date field ", (Throwable)e);
            }
        }
        return aRow;
    }

    private Date process(Object value, String format, Locale locale) throws ParseException {
        if (value == null) {
            return null;
        }
        String strVal = value.toString().trim();
        if (strVal.length() == 0) {
            return null;
        }
        SimpleDateFormat fmt = this.fmtCache.get(format);
        if (fmt == null) {
            fmt = new SimpleDateFormat(format, locale);
            this.fmtCache.put(format, fmt);
        }
        return fmt.parse(strVal);
    }
}

