/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHWriter;
import org.apache.solr.handler.dataimport.DIHWriterBase;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrWriter
extends DIHWriterBase
implements DIHWriter {
    private static final Logger log = LoggerFactory.getLogger(SolrWriter.class);
    public static final String LAST_INDEX_KEY = "last_index_time";
    private final UpdateRequestProcessor processor;
    private final int commitWithin;
    SolrQueryRequest req;

    public SolrWriter(UpdateRequestProcessor processor, SolrQueryRequest req) {
        this.processor = processor;
        this.req = req;
        this.commitWithin = req != null ? req.getParams().getInt("commitWithin", -1) : -1;
    }

    @Override
    public void close() {
        try {
            this.processor.finish();
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Unable to call finish() on UpdateRequestProcessor", e);
        }
    }

    @Override
    public boolean upload(SolrInputDocument d) {
        try {
            AddUpdateCommand command = new AddUpdateCommand(this.req);
            command.solrDoc = d;
            command.commitWithin = this.commitWithin;
            this.processor.processAdd(command);
        }
        catch (Exception e) {
            log.warn("Error creating document : " + d, (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void deleteDoc(Object id) {
        try {
            log.info("Deleting document: " + id);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand(this.req);
            delCmd.setId(id.toString());
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            log.error("Exception while deleteing: " + id, (Throwable)e);
        }
    }

    @Override
    public void deleteByQuery(String query) {
        try {
            log.info("Deleting documents from Solr with query: " + query);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand(this.req);
            delCmd.query = query;
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            log.error("Exception while deleting by query: " + query, (Throwable)e);
        }
    }

    @Override
    public void commit(boolean optimize) {
        try {
            CommitUpdateCommand commit = new CommitUpdateCommand(this.req, optimize);
            this.processor.processCommit(commit);
        }
        catch (Exception e) {
            log.error("Exception while solr commit.", (Throwable)e);
        }
    }

    @Override
    public void rollback() {
        try {
            RollbackUpdateCommand rollback = new RollbackUpdateCommand(this.req);
            this.processor.processRollback(rollback);
        }
        catch (Exception e) {
            log.error("Exception during rollback command.", (Throwable)e);
        }
    }

    @Override
    public void doDeleteAll() {
        try {
            DeleteUpdateCommand deleteCommand = new DeleteUpdateCommand(this.req);
            deleteCommand.query = "*:*";
            this.processor.processDelete(deleteCommand);
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Exception in full dump while deleting all documents.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getResourceAsString(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        int sz = 0;
        try {
            while ((sz = in.read(buf)) != -1) {
                baos.write(buf, 0, sz);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    static String getDocCount() {
        if (DocBuilder.INSTANCE.get() != null) {
            return "" + (DocBuilder.INSTANCE.get().importStatistics.docCount.get() + 1L);
        }
        return null;
    }

    @Override
    public void init(Context context) {
    }
}

