/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigParseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigParseUtil.class);

    public static String getStringAttribute(Element e, String name, String def) {
        String r = e.getAttribute(name);
        if (r == null || "".equals(r.trim())) {
            r = def;
        }
        return r;
    }

    public static HashMap<String, String> getAllAttributes(Element e) {
        HashMap<String, String> m = new HashMap<String, String>();
        NamedNodeMap nnm = e.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            m.put(nnm.item(i).getNodeName(), nnm.item(i).getNodeValue());
        }
        return m;
    }

    public static String getText(Node elem, StringBuilder buffer) {
        if (elem.getNodeType() != 4) {
            NodeList childs = elem.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                short childType = child.getNodeType();
                if (childType == 8 || childType == 7) continue;
                ConfigParseUtil.getText(child, buffer);
            }
        } else {
            buffer.append(elem.getNodeValue());
        }
        return buffer.toString();
    }

    public static List<Element> getChildNodes(Element e, String byName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList l = e.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (!e.equals(l.item(i).getParentNode()) || !byName.equals(l.item(i).getNodeName())) continue;
            result.add((Element)l.item(i));
        }
        return result;
    }

    public static void verifyWithSchema(DataImporter di, Map<String, EntityField> fields) {
        Map schemaFields = null;
        schemaFields = di.getSchema() == null ? Collections.emptyMap() : di.getSchema().getFields();
        for (Map.Entry entry : schemaFields.entrySet()) {
            SchemaField sf = (SchemaField)entry.getValue();
            if (fields.containsKey(sf.getName()) || !sf.isRequired()) continue;
            LOG.info(sf.getName() + " is a required field in SolrSchema . But not found in DataConfig");
        }
        for (Map.Entry<Object, Object> entry : fields.entrySet()) {
            EntityField fld = (EntityField)entry.getValue();
            SchemaField field = di.getSchemaField(fld.getName());
            if (field != null) continue;
            LOG.info("The field :" + fld.getName() + " present in DataConfig does not have a counterpart in Solr Schema");
        }
    }

    public static Map<String, EntityField> gatherAllFields(DataImporter di, Entity e) {
        HashMap<String, EntityField> fields = new HashMap<String, EntityField>();
        if (e.getFields() != null) {
            for (EntityField f : e.getFields()) {
                fields.put(f.getName(), f);
            }
        }
        for (Entity e1 : e.getChildren()) {
            fields.putAll(ConfigParseUtil.gatherAllFields(di, e1));
        }
        return fields;
    }
}

