/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.handler.dataimport.DIHPropertiesWriter;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPropertiesWriter
implements DIHPropertiesWriter {
    private static final Logger log = LoggerFactory.getLogger(ZKPropertiesWriter.class);
    private String path;
    private SolrZkClient zkClient;

    @Override
    public void init(DataImporter dataImporter) {
        String collection = dataImporter.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String persistFilename = dataImporter.getHandlerName() != null ? dataImporter.getHandlerName() + ".properties" : "dataimport.properties";
        this.path = "/configs/" + collection + "/" + persistFilename;
        this.zkClient = dataImporter.getCore().getCoreDescriptor().getCoreContainer().getZkController().getZkClient();
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void persist(Properties props) {
        Properties existing = this.readIndexerProperties();
        existing.putAll((Map<?, ?>)props);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            existing.store(output, "");
            byte[] bytes = output.toByteArray();
            if (!this.zkClient.exists(this.path, false).booleanValue()) {
                try {
                    this.zkClient.makePath(this.path, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    // empty catch block
                }
            }
            this.zkClient.setData(this.path, bytes, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Could not persist properties to " + this.path + " :" + e.getClass(), (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Could not persist properties to " + this.path + " :" + e.getClass(), (Throwable)e);
        }
    }

    @Override
    public Properties readIndexerProperties() {
        Properties props = new Properties();
        try {
            byte[] data = this.zkClient.getData(this.path, null, null, false);
            if (data != null) {
                ByteArrayInputStream input = new ByteArrayInputStream(data);
                props.load(input);
            }
        }
        catch (Throwable e) {
            log.warn("Could not read DIH properties from " + this.path + " :" + e.getClass(), e);
        }
        return props;
    }
}

