/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.dataimport.DebugInfo;

public class RequestInfo {
    private final String command;
    private final boolean debug;
    private final boolean syncMode;
    private final boolean commit;
    private final boolean optimize;
    private final int start;
    private final long rows;
    private final boolean clean;
    private final List<String> entitiesToRun;
    private final Map<String, Object> rawParams;
    private final String dataConfig;
    private final ContentStream contentStream;
    private final DebugInfo debugInfo;

    public RequestInfo(Map<String, Object> requestParams, ContentStream stream) {
        this.contentStream = stream;
        this.command = requestParams.containsKey("command") ? (String)requestParams.get("command") : null;
        boolean debugMode = StrUtils.parseBool((String)((String)requestParams.get("debug")), (boolean)false);
        if (debugMode) {
            this.debug = true;
            this.debugInfo = new DebugInfo(requestParams);
        } else {
            this.debug = false;
            this.debugInfo = null;
        }
        this.clean = requestParams.containsKey("clean") ? StrUtils.parseBool((String)((String)requestParams.get("clean")), (boolean)true) : ("delta-import".equals(this.command) || "import".equals(this.command) ? false : !this.debug);
        this.optimize = StrUtils.parseBool((String)((String)requestParams.get("optimize")), (boolean)false);
        this.commit = this.optimize ? true : StrUtils.parseBool((String)((String)requestParams.get("commit")), (!this.debug ? 1 : 0) != 0);
        this.rows = requestParams.containsKey("rows") ? (long)Integer.parseInt((String)requestParams.get("rows")) : (this.debug ? 10L : Long.MAX_VALUE);
        this.start = requestParams.containsKey("start") ? Integer.parseInt((String)requestParams.get("start")) : 0;
        this.syncMode = StrUtils.parseBool((String)((String)requestParams.get("synchronous")), (boolean)false);
        Object o = requestParams.get("entity");
        ArrayList<String> modifiableEntities = null;
        if (o != null) {
            if (o instanceof String) {
                modifiableEntities = new ArrayList<String>();
                modifiableEntities.add((String)o);
            } else if (o instanceof List) {
                ArrayList modifiableEntities1 = new ArrayList((List)o);
                modifiableEntities = modifiableEntities1;
            }
            this.entitiesToRun = Collections.unmodifiableList(modifiableEntities);
        } else {
            this.entitiesToRun = null;
        }
        String dataConfigParam = (String)requestParams.get("dataConfig");
        if (dataConfigParam != null && dataConfigParam.trim().length() == 0) {
            dataConfigParam = null;
        }
        this.dataConfig = dataConfigParam;
        this.rawParams = Collections.unmodifiableMap(new HashMap<String, Object>(requestParams));
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public int getStart() {
        return this.start;
    }

    public long getRows() {
        return this.rows;
    }

    public boolean isClean() {
        return this.clean;
    }

    public List<String> getEntitiesToRun() {
        return this.entitiesToRun;
    }

    public String getDataConfig() {
        return this.dataConfig;
    }

    public Map<String, Object> getRawParams() {
        return this.rawParams;
    }

    public ContentStream getContentStream() {
        return this.contentStream;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

