/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DIHPropertiesWriter;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.JdbcDataSource;
import org.apache.solr.handler.dataimport.RequestInfo;
import org.apache.solr.handler.dataimport.SimplePropertiesWriter;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.ZKPropertiesWriter;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.Entity;
import org.apache.solr.handler.dataimport.config.Script;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(DataImporter.class);
    private static final XMLErrorLogger XMLLOG = new XMLErrorLogger(LOG);
    private Status status = Status.IDLE;
    private DIHConfiguration config;
    private Date indexStartTime;
    private Properties store = new Properties();
    private Map<String, Properties> dataSourceProps = new HashMap<String, Properties>();
    private IndexSchema schema;
    public DocBuilder docBuilder;
    public DocBuilder.Statistics cumulativeStatistics = new DocBuilder.Statistics();
    private SolrCore core;
    private DIHPropertiesWriter propWriter;
    private ReentrantLock importLock = new ReentrantLock();
    private final Map<String, Object> coreScopeSession;
    private boolean isDeltaImportSupported = false;
    private final String handlerName;
    private Map<String, SchemaField> lowerNameVsSchemaField = new HashMap<String, SchemaField>();
    static final ThreadLocal<AtomicLong> QUERY_COUNT = new ThreadLocal<AtomicLong>(){

        @Override
        protected AtomicLong initialValue() {
            return new AtomicLong();
        }
    };
    static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    public static final String DATA_SRC = "dataSource";
    public static final String MULTI_VALUED = "multiValued";
    public static final String NAME = "name";
    public static final String STATUS_MSGS = "status-messages";
    public static final String FULL_IMPORT_CMD = "full-import";
    public static final String IMPORT_CMD = "import";
    public static final String DELTA_IMPORT_CMD = "delta-import";
    public static final String ABORT_CMD = "abort";
    public static final String DEBUG_MODE = "debug";
    public static final String RELOAD_CONF_CMD = "reload-config";
    public static final String SHOW_CONF_CMD = "show-config";

    DataImporter() {
        this.coreScopeSession = new HashMap<String, Object>();
        this.createPropertyWriter();
        this.propWriter.init(this);
        this.handlerName = "dataimport";
    }

    private void createPropertyWriter() {
        this.propWriter = this.core == null || !this.core.getCoreDescriptor().getCoreContainer().isZooKeeperAware() ? new SimplePropertiesWriter() : new ZKPropertiesWriter();
        this.propWriter.init(this);
    }

    DataImporter(InputSource dataConfig, SolrCore core, Map<String, Properties> ds, Map<String, Object> session, String handlerName) {
        this.handlerName = handlerName;
        if (dataConfig == null) {
            throw new DataImportHandlerException(500, "Configuration not found");
        }
        this.core = core;
        this.schema = core.getSchema();
        this.loadSchemaFieldMap();
        this.createPropertyWriter();
        this.dataSourceProps = ds;
        if (session == null) {
            session = new HashMap<String, Object>();
        }
        this.coreScopeSession = session;
        this.loadDataConfig(dataConfig);
        for (Entity e : this.config.getEntities()) {
            if (!e.getAllAttributes().containsKey("deltaQuery")) continue;
            this.isDeltaImportSupported = true;
            break;
        }
    }

    private void loadSchemaFieldMap() {
        HashMap modLnvsf = new HashMap();
        for (Map.Entry entry : this.schema.getFields().entrySet()) {
            modLnvsf.put(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        this.lowerNameVsSchemaField = Collections.unmodifiableMap(modLnvsf);
    }

    public SchemaField getSchemaField(String caseInsensitiveName) {
        SchemaField schemaField = null;
        if (this.schema != null) {
            schemaField = this.schema.getFieldOrNull(caseInsensitiveName);
        }
        if (schemaField == null) {
            schemaField = this.lowerNameVsSchemaField.get(caseInsensitiveName.toLowerCase(Locale.ENGLISH));
        }
        return schemaField;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    void loadAndInit(String configStr) {
        this.loadDataConfig(new InputSource(new StringReader(configStr)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataConfig(InputSource configFile) {
        try {
            Document document;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (this.core != null && configFile.getSystemId() != null) {
                try {
                    dbf.setXIncludeAware(true);
                    dbf.setNamespaceAware(true);
                }
                catch (UnsupportedOperationException e) {
                    LOG.warn("XML parser doesn't support XInclude option");
                }
            }
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (this.core != null) {
                builder.setEntityResolver((EntityResolver)new SystemIdResolver((ResourceLoader)this.core.getResourceLoader()));
            }
            builder.setErrorHandler((ErrorHandler)XMLLOG);
            try {
                document = builder.parse(configFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)configFile.getByteStream());
            }
            this.config = this.readFromXml(document);
            LOG.info("Data Configuration loaded successfully");
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Exception occurred while initializing context", e);
        }
    }

    public DIHConfiguration readFromXml(Document xmlDocument) {
        Iterator<Element> i$;
        List<Element> dataSourceTags;
        List<Element> functionTags;
        ArrayList<Map<String, String>> functions = new ArrayList<Map<String, String>>();
        Script script = null;
        HashMap<String, Properties> dataSources = new HashMap<String, Properties>();
        NodeList dataConfigTags = xmlDocument.getElementsByTagName("dataConfig");
        if (dataConfigTags == null || dataConfigTags.getLength() == 0) {
            throw new DataImportHandlerException(500, "the root node '<dataConfig>' is missing");
        }
        Element e = (Element)dataConfigTags.item(0);
        List<Element> documentTags = ConfigParseUtil.getChildNodes(e, "document");
        if (documentTags.isEmpty()) {
            throw new DataImportHandlerException(500, "DataImportHandler configuration file must have one <document> node.");
        }
        List<Element> scriptTags = ConfigParseUtil.getChildNodes(e, "script");
        if (!scriptTags.isEmpty()) {
            script = new Script(scriptTags.get(0));
        }
        if (!(functionTags = ConfigParseUtil.getChildNodes(e, "function")).isEmpty()) {
            for (Element element : functionTags) {
                String func = ConfigParseUtil.getStringAttribute(element, NAME, null);
                String clz = ConfigParseUtil.getStringAttribute(element, "class", null);
                if (func == null || clz == null) {
                    throw new DataImportHandlerException(500, "<function> must have a 'name' and 'class' attributes");
                }
                functions.add(ConfigParseUtil.getAllAttributes(element));
            }
        }
        if (!(dataSourceTags = ConfigParseUtil.getChildNodes(e, DATA_SRC)).isEmpty()) {
            i$ = dataSourceTags.iterator();
            while (i$.hasNext()) {
                Element element = i$.next();
                Properties p = new Properties();
                HashMap<String, String> attrs = ConfigParseUtil.getAllAttributes(element);
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    p.setProperty(entry.getKey(), entry.getValue());
                }
                dataSources.put(p.getProperty(NAME), p);
            }
        }
        if (dataSources.get(null) == null && (i$ = dataSources.values().iterator()).hasNext()) {
            Properties properties = (Properties)((Object)i$.next());
            dataSources.put(null, properties);
        }
        return new DIHConfiguration(documentTags.get(0), this, functions, script, dataSources);
    }

    DIHConfiguration getConfig() {
        return this.config;
    }

    Date getIndexStartTime() {
        return this.indexStartTime;
    }

    void setIndexStartTime(Date indextStartTime) {
        this.indexStartTime = indextStartTime;
    }

    void store(Object key, Object value) {
        this.store.put(key, value);
    }

    Object retrieve(Object key) {
        return this.store.get(key);
    }

    DataSource getDataSourceInstance(Entity key, String name, Context ctx) {
        Properties p = this.dataSourceProps.get(name);
        if (p == null) {
            p = this.config.getDataSources().get(name);
        }
        if (p == null) {
            p = this.dataSourceProps.get(null);
        }
        if (p == null) {
            p = this.config.getDataSources().get(null);
        }
        if (p == null) {
            throw new DataImportHandlerException(500, "No dataSource :" + name + " available for entity :" + key.getName());
        }
        String type = p.getProperty(TYPE);
        DataSource dataSrc = null;
        if (type == null) {
            dataSrc = new JdbcDataSource();
        } else {
            try {
                dataSrc = (DataSource)DocBuilder.loadClass(type, this.getCore()).newInstance();
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Invalid type for data source: " + type);
            }
        }
        try {
            Properties copyProps = new Properties();
            copyProps.putAll((Map<?, ?>)p);
            Map<String, Object> map = ctx.getRequestParameters();
            if (map.containsKey("rows")) {
                int rows = Integer.parseInt((String)map.get("rows"));
                if (map.containsKey("start")) {
                    rows += Integer.parseInt((String)map.get("start"));
                }
                copyProps.setProperty("maxRows", String.valueOf(rows));
            }
            dataSrc.init(ctx, copyProps);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Failed to initialize DataSource: " + key.getDataSourceName());
        }
        return dataSrc;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBusy() {
        return this.importLock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFullImport(SolrWriter writer, RequestInfo requestParams) {
        LOG.info("Starting Full Import");
        this.setStatus(Status.RUNNING_FULL_DUMP);
        this.setIndexStartTime(new Date());
        try {
            this.docBuilder = new DocBuilder(this, writer, this.propWriter, requestParams);
            this.checkWritablePersistFile(writer);
            this.docBuilder.execute();
            if (!requestParams.isDebug()) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (Throwable t) {
            SolrException.log((Logger)LOG, (String)"Full Import failed", (Throwable)t);
            this.docBuilder.rollback();
        }
        finally {
            this.setStatus(Status.IDLE);
            DocBuilder.INSTANCE.set(null);
        }
    }

    private void checkWritablePersistFile(SolrWriter writer) {
        if (this.isDeltaImportSupported && !this.propWriter.isWritable()) {
            throw new DataImportHandlerException(500, "Properties is not writable. Delta imports are supported by data config but will not work.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeltaImport(SolrWriter writer, RequestInfo requestParams) {
        LOG.info("Starting Delta Import");
        this.setStatus(Status.RUNNING_DELTA_DUMP);
        try {
            this.setIndexStartTime(new Date());
            this.docBuilder = new DocBuilder(this, writer, this.propWriter, requestParams);
            this.checkWritablePersistFile(writer);
            this.docBuilder.execute();
            if (!requestParams.isDebug()) {
                this.cumulativeStatistics.add(this.docBuilder.importStatistics);
            }
        }
        catch (Throwable t) {
            LOG.error("Delta Import Failed", t);
            this.docBuilder.rollback();
        }
        finally {
            this.setStatus(Status.IDLE);
            DocBuilder.INSTANCE.set(null);
        }
    }

    public void runAsync(final RequestInfo reqParams, final SolrWriter sw) {
        new Thread(){

            @Override
            public void run() {
                DataImporter.this.runCmd(reqParams, sw);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCmd(RequestInfo reqParams, SolrWriter sw) {
        String command = reqParams.getCommand();
        if (command.equals(ABORT_CMD)) {
            if (this.docBuilder != null) {
                this.docBuilder.abort();
            }
            return;
        }
        if (!this.importLock.tryLock()) {
            LOG.warn("Import command failed . another import is running");
            return;
        }
        try {
            if (FULL_IMPORT_CMD.equals(command) || IMPORT_CMD.equals(command)) {
                this.doFullImport(sw, reqParams);
            } else if (command.equals(DELTA_IMPORT_CMD)) {
                this.doDeltaImport(sw, reqParams);
            }
        }
        finally {
            this.importLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getStatusMessages() {
        Map statusMessages = (Map)this.retrieve(STATUS_MSGS);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (statusMessages != null) {
            Map map = statusMessages;
            synchronized (map) {
                Iterator i$ = statusMessages.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = i$.next();
                    result.put((String)e.getKey(), e.getValue().toString());
                }
            }
        }
        return result;
    }

    DocBuilder getDocBuilder() {
        return this.docBuilder;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    Map<String, Object> getCoreScopeSession() {
        return this.coreScopeSession;
    }

    SolrCore getCore() {
        return this.core;
    }

    static final class MSG {
        public static final String NO_CONFIG_FOUND = "Configuration not found";
        public static final String NO_INIT = "DataImportHandler started. Not Initialized. No commands can be run";
        public static final String INVALID_CONFIG = "FATAL: Could not create importer. DataImporter config invalid";
        public static final String LOAD_EXP = "Exception while loading DataImporter";
        public static final String JMX_DESC = "Manage data import from databases to Solr";
        public static final String CMD_RUNNING = "A command is still running...";
        public static final String DEBUG_NOT_ENABLED = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
        public static final String CONFIG_RELOADED = "Configuration Re-loaded sucessfully";
        public static final String TOTAL_DOC_PROCESSED = "Total Documents Processed";
        public static final String TOTAL_FAILED_DOCS = "Total Documents Failed";
        public static final String TOTAL_QUERIES_EXECUTED = "Total Requests made to DataSource";
        public static final String TOTAL_ROWS_EXECUTED = "Total Rows Fetched";
        public static final String TOTAL_DOCS_DELETED = "Total Documents Deleted";
        public static final String TOTAL_DOCS_SKIPPED = "Total Documents Skipped";

        MSG() {
        }
    }

    public static enum Status {
        IDLE,
        RUNNING_FULL_DUMP,
        RUNNING_DELTA_DUMP,
        JOB_FAILED;

    }
}

