/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTransformer
extends Transformer {
    private Object engine;
    private Method invokeFunctionMethod;
    private String functionName;

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        try {
            if (this.engine == null) {
                this.initEngine(context);
            }
            if (this.engine == null) {
                return row;
            }
            return this.invokeFunctionMethod.invoke(this.engine, this.functionName, new Object[]{row, context});
        }
        catch (DataImportHandlerException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new DataImportHandlerException(500, "Could not invoke method :" + this.functionName + "\n <script>\n" + context.getVariableResolver().resolve("dataimporter.script") + "</script>", e);
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "Error invoking script for entity " + context.getEntityAttribute("name"), e);
        }
    }

    private void initEngine(Context context) {
        try {
            String scriptText = context.getScript();
            String scriptLang = context.getScriptLanguage();
            Object scriptEngineMgr = Class.forName("javax.script.ScriptEngineManager").newInstance();
            Method getEngineMethod = scriptEngineMgr.getClass().getMethod("getEngineByName", String.class);
            this.engine = getEngineMethod.invoke(scriptEngineMgr, scriptLang);
            Method evalMethod = this.engine.getClass().getMethod("eval", String.class);
            this.invokeFunctionMethod = this.engine.getClass().getMethod("invokeFunction", String.class, Object[].class);
            evalMethod.invoke(this.engine, scriptText);
        }
        catch (Exception e) {
            throw new DataImportHandlerException(500, "<script> can be used only in java 6 or above", e);
        }
    }

    public void setFunctionName(String methodName) {
        this.functionName = methodName;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

