/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextEntityProcessor.class);
    private boolean ended = false;
    public static final String PLAIN_TEXT = "plainText";

    @Override
    public void init(Context context) {
        super.init(context);
        this.ended = false;
    }

    @Override
    public Map<String, Object> nextRow() {
        if (this.ended) {
            return null;
        }
        DataSource ds = this.context.getDataSource();
        String url = this.context.getVariableResolver().replaceTokens(this.context.getEntityAttribute("url"));
        Reader r = null;
        try {
            r = (Reader)ds.getData(url);
        }
        catch (Exception e) {
            if ("abort".equals(this.onError)) {
                DataImportHandlerException.wrapAndThrow(500, e, "Exception reading url : " + url);
            }
            return null;
        }
        StringWriter sw = new StringWriter();
        char[] buf = new char[1024];
        while (true) {
            int len = 0;
            try {
                len = r.read(buf);
            }
            catch (IOException e) {
                if ("abort".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(500, e, "Exception reading url : " + url);
                }
                LOG.warn("IOException while reading from data source", (Throwable)e);
                return null;
            }
            if (len <= 0) break;
            sw.append(new String(buf, 0, len));
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put(PLAIN_TEXT, sw.toString());
        this.ended = true;
        return row;
    }
}

