/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.apache.solr.util.DateMathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorBag {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluatorBag.class);
    public static final String DATE_FORMAT_EVALUATOR = "formatDate";
    public static final String URL_ENCODE_EVALUATOR = "encodeUrl";
    public static final String ESCAPE_SOLR_QUERY_CHARS = "escapeQueryChars";
    public static final String SQL_ESCAPE_EVALUATOR = "escapeSql";
    static final Pattern FORMAT_METHOD = Pattern.compile("^(\\w*?)\\((.*?)\\)$");
    static Pattern IN_SINGLE_QUOTES = Pattern.compile("^'(.*?)'$");
    static DateMathParser dateMathParser = new DateMathParser(TimeZone.getDefault(), Locale.getDefault());

    public static Evaluator getSqlEscapingEvaluator() {
        return new Evaluator(){

            public String evaluate(String expression, Context context) {
                List l = EvaluatorBag.parseParams(expression, context.getVariableResolver());
                if (l.size() != 1) {
                    throw new DataImportHandlerException(500, "'escapeSql' must have at least one parameter ");
                }
                String s = l.get(0).toString();
                return s.replaceAll("'", "''").replaceAll("\"", "\"\"");
            }
        };
    }

    public static Evaluator getSolrQueryEscapingEvaluator() {
        return new Evaluator(){

            public String evaluate(String expression, Context context) {
                List l = EvaluatorBag.parseParams(expression, context.getVariableResolver());
                if (l.size() != 1) {
                    throw new DataImportHandlerException(500, "'escapeQueryChars' must have at least one parameter ");
                }
                String s = l.get(0).toString();
                return ClientUtils.escapeQueryChars((String)s);
            }
        };
    }

    public static Evaluator getUrlEvaluator() {
        return new Evaluator(){

            public String evaluate(String expression, Context context) {
                List l = EvaluatorBag.parseParams(expression, context.getVariableResolver());
                if (l.size() != 1) {
                    throw new DataImportHandlerException(500, "'encodeUrl' must have at least one parameter ");
                }
                String s = l.get(0).toString();
                try {
                    return URLEncoder.encode(s.toString(), "UTF-8");
                }
                catch (Exception e) {
                    DataImportHandlerException.wrapAndThrow(500, e, "Unable to encode expression: " + expression + " with value: " + s);
                    return null;
                }
            }
        };
    }

    public static Evaluator getDateFormatEvaluator() {
        return new Evaluator(){

            public String evaluate(String expression, Context context) {
                List l = EvaluatorBag.parseParams(expression, context.getVariableResolver());
                if (l.size() != 2) {
                    throw new DataImportHandlerException(500, "'formatDate()' must have two parameters ");
                }
                Object o = l.get(0);
                Object format = l.get(1);
                if (format instanceof VariableWrapper) {
                    VariableWrapper wrapper = (VariableWrapper)format;
                    o = wrapper.resolve();
                    if (o == null) {
                        format = wrapper.varName;
                        LOG.warn("Deprecated syntax used. The syntax of formatDate has been changed to formatDate(<var>, '<date_format_string>'). The old syntax will stop working in Solr 1.5");
                    } else {
                        format = o.toString();
                    }
                }
                String dateFmt = format.toString();
                SimpleDateFormat fmt = new SimpleDateFormat(dateFmt);
                Date date = null;
                if (o instanceof VariableWrapper) {
                    VariableWrapper variableWrapper = (VariableWrapper)o;
                    Object variableval = variableWrapper.resolve();
                    if (variableval instanceof Date) {
                        date = (Date)variableval;
                    } else {
                        String s = variableval.toString();
                        try {
                            date = DataImporter.DATE_TIME_FORMAT.get().parse(s);
                        }
                        catch (ParseException exp) {
                            DataImportHandlerException.wrapAndThrow(500, exp, "Invalid expression for date");
                        }
                    }
                } else {
                    String datemathfmt = o.toString();
                    datemathfmt = datemathfmt.replaceAll("NOW", "");
                    try {
                        date = dateMathParser.parseMath(datemathfmt);
                    }
                    catch (ParseException e) {
                        DataImportHandlerException.wrapAndThrow(500, e, "Invalid expression for date");
                    }
                }
                return fmt.format(date);
            }
        };
    }

    static Map<String, Object> getFunctionsNamespace(List<Map<String, String>> fn, DocBuilder docBuilder) {
        final HashMap<String, Evaluator> evaluators = new HashMap<String, Evaluator>();
        evaluators.put(DATE_FORMAT_EVALUATOR, EvaluatorBag.getDateFormatEvaluator());
        evaluators.put(SQL_ESCAPE_EVALUATOR, EvaluatorBag.getSqlEscapingEvaluator());
        evaluators.put(URL_ENCODE_EVALUATOR, EvaluatorBag.getUrlEvaluator());
        evaluators.put(ESCAPE_SOLR_QUERY_CHARS, EvaluatorBag.getSolrQueryEscapingEvaluator());
        SolrCore core = docBuilder == null ? null : docBuilder.dataImporter.getCore();
        for (Map<String, String> map : fn) {
            try {
                evaluators.put(map.get("name"), (Evaluator)DocBuilder.loadClass(map.get("class"), core).newInstance());
            }
            catch (Exception e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to instantiate evaluator: " + map.get("class"));
            }
        }
        return new HashMap<String, Object>(){

            @Override
            public String get(Object key) {
                if (key == null) {
                    return null;
                }
                Matcher m = FORMAT_METHOD.matcher((String)key);
                if (!m.find()) {
                    return null;
                }
                String fname = m.group(1);
                Evaluator evaluator = (Evaluator)evaluators.get(fname);
                if (evaluator == null) {
                    return null;
                }
                VariableResolverImpl vri = VariableResolverImpl.CURRENT_VARIABLE_RESOLVER.get();
                Context ctx = vri == null ? null : vri.context;
                return evaluator.evaluate(m.group(2), ctx);
            }
        };
    }

    public static List parseParams(String expression, VariableResolver vr) {
        ArrayList<Object> result = new ArrayList<Object>();
        expression = expression.trim();
        String[] ss = expression.split(",");
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = ss[i].trim();
            if (ss[i].startsWith("'")) {
                StringBuilder sb = new StringBuilder();
                while (true) {
                    sb.append(ss[i]);
                    if (ss[i].endsWith("'")) break;
                    if (++i >= ss.length) {
                        throw new DataImportHandlerException(500, "invalid string at " + ss[i - 1] + " in function params: " + expression);
                    }
                    sb.append(",");
                }
                String s = sb.substring(1, sb.length() - 1);
                s = s.replaceAll("\\\\'", "'");
                result.add(s);
                continue;
            }
            if (Character.isDigit(ss[i].charAt(0))) {
                try {
                    Double doub = Double.parseDouble(ss[i]);
                    result.add(doub);
                }
                catch (NumberFormatException e) {
                    if (vr.resolve(ss[i]) != null) continue;
                    DataImportHandlerException.wrapAndThrow(500, e, "Invalid number :" + ss[i] + "in parameters  " + expression);
                }
                continue;
            }
            result.add(new VariableWrapper(ss[i], vr));
        }
        return result;
    }

    public static class VariableWrapper {
        String varName;
        VariableResolver vr;

        public VariableWrapper(String s, VariableResolver vr) {
            this.varName = s;
            this.vr = vr;
        }

        public Object resolve() {
            return this.vr.resolve(this.varName);
        }

        public String toString() {
            Object o = this.vr.resolve(this.varName);
            return o == null ? null : o.toString();
        }
    }
}

