/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.security.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.whiteboard.Preprocessor;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Preprocessor.class}, property={"osgi.http.whiteboard.filter.pattern=/", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)"})
@Designate(ocd=Config.class)
public class ReferrerFilter
implements Preprocessor {
    private static final String USER_AGENT = "User-Agent";
    private static final String BROWSER_CLASS_MOZILLA = "Mozilla";
    private static final String BROWSER_CLASS_OPERA = "Opera";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean allowEmpty;
    private URL[] allowedUriReferrers;
    private Pattern[] allowedRegexReferrers;
    private String[] filterMethods;
    private Pattern[] excludedRegexUserAgents;
    private ServiceRegistration<Object> configPrinterRegistration;

    private Set<String> getDefaultAllowedReferrers() {
        HashSet<String> referrers = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                this.logger.info("Adding Allowed referers for Interface:" + iface.getDisplayName());
                Enumeration<InetAddress> ias = iface.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress ia = ias.nextElement();
                    String address = ia.getHostAddress().trim().toLowerCase();
                    if (ia instanceof Inet4Address) {
                        referrers.add("http://" + address + ":0");
                        referrers.add("https://" + address + ":0");
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    referrers.add("http://[" + address + "]:0");
                    referrers.add("https://[" + address + "]:0");
                }
            }
        }
        catch (SocketException se) {
            this.logger.error("Unable to detect network interfaces", (Throwable)se);
        }
        referrers.add("http://localhost:0");
        referrers.add("http://127.0.0.1:0");
        referrers.add("http://[::1]:0");
        referrers.add("https://localhost:0");
        referrers.add("https://127.0.0.1:0");
        referrers.add("https://[::1]:0");
        return referrers;
    }

    private void add(List<URL> urls, String ref) {
        try {
            URL u = new URL(ref);
            urls.add(u);
        }
        catch (MalformedURLException mue) {
            this.logger.warn("Unable to create URL from " + ref + " : " + mue.getMessage());
        }
    }

    private URL[] createReferrerUrls(Set<String> referrers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String ref : referrers) {
            int pos = ref.indexOf("://");
            if (pos != -1) {
                this.add(urls, ref);
                continue;
            }
            this.add(urls, "http://" + ref + ":0");
            this.add(urls, "https://" + ref + ":0");
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private Pattern[] createRegexPatterns(String[] regexps) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (regexps != null) {
            for (String regexp : regexps) {
                try {
                    Pattern pattern = Pattern.compile(regexp);
                    patterns.add(pattern);
                }
                catch (Exception e) {
                    this.logger.warn("Unable to create Pattern from {} : {}", new Object[]{regexp, e.getMessage()});
                }
            }
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    @Activate
    protected void activate(BundleContext context, Config config) {
        this.allowEmpty = config.allow_empty();
        this.allowedRegexReferrers = this.createRegexPatterns(config.allow_hosts_regexp());
        this.excludedRegexUserAgents = this.createRegexPatterns(config.exclude_agents_regexp());
        Set<String> allowUriReferrers = this.getDefaultAllowedReferrers();
        if (config.allow_hosts() != null) {
            allowUriReferrers.addAll(Arrays.asList(config.allow_hosts()));
        }
        this.allowedUriReferrers = this.createReferrerUrls(allowUriReferrers);
        this.filterMethods = config.filter_methods();
        if (this.filterMethods != null && this.filterMethods.length == 1 && (this.filterMethods[0] == null || this.filterMethods[0].trim().length() == 0)) {
            this.filterMethods = null;
        }
        if (this.filterMethods != null) {
            for (int i = 0; i < this.filterMethods.length; ++i) {
                this.filterMethods[i] = this.filterMethods[i].toUpperCase();
            }
        }
        this.configPrinterRegistration = this.registerConfigPrinter(context);
    }

    @Deactivate
    protected void deactivate() {
        this.configPrinterRegistration.unregister();
    }

    private ServiceRegistration<Object> registerConfigPrinter(BundleContext bundleContext) {
        ConfigurationPrinter cfgPrinter = new ConfigurationPrinter();
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Referrer Filter Configuration Printer");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)serviceProps).put("felix.webconsole.label", "slingreferrerfilter");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Referrer Filter");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        return bundleContext.registerService(Object.class, (Object)cfgPrinter, serviceProps);
    }

    private boolean isModification(HttpServletRequest req) {
        String method = req.getMethod();
        if (this.filterMethods != null) {
            for (String m : this.filterMethods) {
                if (!m.equals(method)) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request;
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse && this.isBrowserRequest(request = (HttpServletRequest)req) && this.isModification(request) && !this.isValidRequest(request)) {
            HttpServletResponse response = (HttpServletResponse)res;
            response.sendError(403);
            return;
        }
        chain.doFilter(req, res);
    }

    HostInfo getHost(String referrer) {
        int startPos = referrer.indexOf("://") + 3;
        if (startPos == 2 || startPos == referrer.length()) {
            return null;
        }
        HostInfo info = new HostInfo();
        info.scheme = referrer.substring(0, startPos - 3);
        int paramStart = referrer.indexOf(63);
        String hostAndPath = paramStart == -1 ? referrer : referrer.substring(0, paramStart);
        int endPos = hostAndPath.indexOf(47, startPos);
        String hostPart = endPos == -1 ? hostAndPath.substring(startPos) : hostAndPath.substring(startPos, endPos);
        int hostNameStart = hostPart.indexOf(64) + 1;
        int hostNameEnd = hostPart.lastIndexOf(58);
        if (hostNameEnd < hostNameStart) {
            info.host = hostPart.substring(hostNameStart);
            if (info.scheme.equals("http")) {
                info.port = 80;
            } else if (info.scheme.equals("https")) {
                info.port = 443;
            }
        } else {
            info.host = hostPart.substring(hostNameStart, hostNameEnd);
            info.port = Integer.valueOf(hostPart.substring(hostNameEnd + 1));
        }
        return info;
    }

    boolean isValidRequest(HttpServletRequest request) {
        boolean valid;
        String referrer = request.getHeader("referer");
        if (referrer == null || referrer.trim().length() == 0) {
            if (!this.allowEmpty) {
                this.logger.info("Rejected empty referrer header for {} request to {}", (Object)request.getMethod(), (Object)request.getRequestURI());
            }
            return this.allowEmpty;
        }
        if (referrer.indexOf(":/") == -1) {
            return true;
        }
        HostInfo info = this.getHost(referrer);
        if (info == null) {
            this.logger.info("Rejected illegal referrer header for {} request to {} : {}", new Object[]{request.getMethod(), request.getRequestURI(), referrer});
            return false;
        }
        if (info.host.equals(request.getServerName())) {
            return true;
        }
        boolean bl = valid = this.isValidUriReferrer(info) || this.isValidRegexReferrer(info);
        if (!valid) {
            this.logger.info("Rejected referrer header for {} request to {} : {}", new Object[]{request.getMethod(), request.getRequestURI(), referrer});
        }
        return valid;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    private boolean isValidUriReferrer(HostInfo hostInfo) {
        for (URL ref : this.allowedUriReferrers) {
            if (!hostInfo.host.equals(ref.getHost()) || !hostInfo.scheme.equals(ref.getProtocol()) || ref.getPort() != 0 && hostInfo.port != ref.getPort()) continue;
            return true;
        }
        return false;
    }

    private boolean isValidRegexReferrer(HostInfo hostInfo) {
        for (Pattern ref : this.allowedRegexReferrers) {
            String url = hostInfo.toURI();
            if (!ref.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedRegexUserAgent(String userAgent) {
        for (Pattern pattern : this.excludedRegexUserAgents) {
            if (!pattern.matcher(userAgent).matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isBrowserRequest(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        return userAgent != null && (userAgent.contains(BROWSER_CLASS_MOZILLA) || userAgent.contains(BROWSER_CLASS_OPERA)) && !this.isExcludedRegexUserAgent(userAgent);
    }

    public class ConfigurationPrinter {
        public void printConfiguration(PrintWriter pw) {
            pw.println("Current Apache Sling Referrer Filter Allowed Referrers:");
            pw.println();
            for (URL uRL : ReferrerFilter.this.allowedUriReferrers) {
                pw.println(uRL.toString());
            }
            for (Serializable serializable : ReferrerFilter.this.allowedRegexReferrers) {
                pw.println(((Pattern)serializable).toString());
            }
        }
    }

    static final class HostInfo {
        public String host;
        public String scheme;
        public int port;

        HostInfo() {
        }

        public String toURI() {
            return this.scheme + "://" + this.host + ":" + this.port;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Referrer Filter", description="Request filter checking the referrer of modification requests and denying request with a 403 in case the referrer is not allowed")
    public static @interface Config {
        @AttributeDefinition(name="Allow Empty", description="Allow an empty or missing referrer")
        public boolean allow_empty() default false;

        @AttributeDefinition(name="Allow Hosts", description="List of allowed hosts for the referrer which are added to the list of default hosts. It is matched against the full referrer URL in the format \"<scheme>://<host>:<port>\". If port is 0, it is not taken into consideration. The default list contains all host names and IPs bound to all NICs found in the system plus \"localhost\", \"127.0.0.1\", \"[::1]\" for protocols \"http\" and \"https\". If given value does not have a \":\" entries for both http and https are transparently generated.")
        public String[] allow_hosts() default {};

        @AttributeDefinition(name="Allow Regexp Host", description="List of allowed regular expression for the referrer. It is matched against the full referrer URL in the format \"<scheme>://<host>:<port>\". Evaluated in addition to the default list and the given allowed hosts (see above)!")
        public String[] allow_hosts_regexp() default {};

        @AttributeDefinition(name="Filter Methods", description="These methods are filtered by the filter")
        public String[] filter_methods() default {"POST", "PUT", "DELETE", "COPY", "MOVE"};

        @AttributeDefinition(name="Exclude Regexp User Agent", description="List of regexp for user agents not to check the referrer")
        public String[] exclude_agents_regexp() default {};
    }
}

