/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, description="Request filter adding Content Disposition attachment for certain paths/content types", label=" Apache Sling Content Disposition Filter")
@Service(value={Filter.class})
@Properties(value={@Property(name="sling.filter.scope", value={"request"}, propertyPrivate=true), @Property(name="service.ranking", intValue={-25000}, propertyPrivate=true)})
public class ContentDispositionFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Property(label="Content Disposition Paths", description="These paths are checked by the filter. Each entry is of the form 'path [ \":\" CSV of excluded content types ]'. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY, value={""})
    private static final String PROP_CONTENT_DISPOSTION_PATHS = "sling.content.disposition.paths";
    @Property(label="Content Disposition Excluded Paths", description="These paths are excluded by the filter. Each entry is of the form 'path'. ", unbounded=PropertyUnbounded.ARRAY, value={""})
    private static final String PROP_CONTENT_DISPOSTION_EXCLUDED_PATHS = "sling.content.disposition.excluded.paths";
    private static final boolean DEFAULT_ENABLE_CONTENT_DISPOSTION_ALL_PATHS = false;
    @Property(boolValue={false}, label="Enable Content Disposition for all paths", description="This flag controls whether to enable Content Disposition for all paths, except for the excluded paths defined by sling.content.disposition.excluded.paths")
    private static final String PROP_ENABLE_CONTENT_DISPOSTION_ALL_PATHS = "sling.content.disposition.all.paths";
    Set<String> contentDispositionPaths;
    private String[] contentDispositionPathsPfx;
    Set<String> contentDispositionExcludedPaths;
    private Map<String, Set<String>> contentTypesMapping;
    private boolean enableContentDispositionAllPaths;

    @Activate
    private void activate(Map<String, Object> props) {
        String[] contentDispostionProps = PropertiesUtil.toStringArray(props.get(PROP_CONTENT_DISPOSTION_PATHS));
        HashSet paths = new HashSet();
        ArrayList<String> pfxs = new ArrayList<String>();
        HashMap<String, Set<String>> contentTypesMap = new HashMap<String, Set<String>>();
        for (String path : contentDispostionProps) {
            if ((path = path.trim()).length() <= 0) continue;
            int idx = path.indexOf(42);
            int colonIdx = path.indexOf(":");
            if (colonIdx > -1 && colonIdx < idx) {
                this.logger.info("':' in paths is not allowed.");
                continue;
            }
            String p = null;
            if (idx >= 0) {
                if (idx > 0) {
                    p = path.substring(0, idx);
                    pfxs.add(p);
                } else {
                    this.logger.info("catch-all wildcard for paths not allowed.");
                }
            } else {
                p = colonIdx > -1 ? path.substring(0, colonIdx) : path;
                paths.add(p);
            }
            if (colonIdx == -1 || p == null) continue;
            Set<String> contentTypes = ContentDispositionFilter.getContentTypes(path.substring(colonIdx + 1));
            contentTypesMap.put(p, contentTypes);
        }
        this.contentDispositionPaths = paths.isEmpty() ? Collections.emptySet() : paths;
        this.contentDispositionPathsPfx = pfxs.toArray(new String[pfxs.size()]);
        this.contentTypesMapping = contentTypesMap.isEmpty() ? Collections.emptyMap() : contentTypesMap;
        this.enableContentDispositionAllPaths = PropertiesUtil.toBoolean(props.get(PROP_ENABLE_CONTENT_DISPOSTION_ALL_PATHS), false);
        String[] contentDispostionExcludedPathsArray = PropertiesUtil.toStringArray(props.get(PROP_CONTENT_DISPOSTION_EXCLUDED_PATHS));
        this.contentDispositionExcludedPaths = new HashSet<String>(Arrays.asList(contentDispostionExcludedPathsArray));
        this.logger.info("Initialized. content disposition paths: {}, content disposition paths-pfx {}, content disposition excluded paths: {}. Enable Content Disposition for all paths is set to {}", new Object[]{this.contentDispositionPaths, this.contentDispositionPathsPfx, this.contentDispositionExcludedPaths, this.enableContentDispositionAllPaths});
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        RewriterResponse rewriterResponse = new RewriterResponse(slingRequest, slingResponse);
        chain.doFilter(request, (ServletResponse)rewriterResponse);
    }

    private static Set<String> getContentTypes(String contentTypes) {
        HashSet<String> contentTypesSet = new HashSet<String>();
        if (contentTypes != null && contentTypes.length() > 0) {
            String[] contentTypesArray;
            for (String contentType : contentTypesArray = contentTypes.split(",")) {
                contentTypesSet.add(contentType);
            }
        }
        return contentTypesSet;
    }

    protected class RewriterResponse
    extends SlingHttpServletResponseWrapper {
        private static final String CONTENT_DISPOSTION = "Content-Disposition";
        private static final String CONTENT_DISPOSTION_ATTACHMENT = "attachment";
        private static final String PROP_JCR_DATA = "jcr:data";
        private static final String JCR_CONTENT_LEAF = "jcr:content";
        static final String ATTRIBUTE_NAME = "org.apache.sling.security.impl.ContentDispositionFilter.RewriterResponse.contentType";
        private final SlingHttpServletRequest request;
        private final Resource resource;

        public RewriterResponse(SlingHttpServletRequest request, SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
            this.request = request;
            this.resource = request.getResource();
        }

        public void reset() {
            this.request.removeAttribute(ATTRIBUTE_NAME);
            super.reset();
        }

        public void setContentType(String type) {
            if ("GET".equals(this.request.getMethod())) {
                String previousContentType = (String)this.request.getAttribute(ATTRIBUTE_NAME);
                if (previousContentType != null && previousContentType.equals(type)) {
                    return;
                }
                this.request.setAttribute(ATTRIBUTE_NAME, (Object)type);
                String resourcePath = this.resource.getPath();
                if (!ContentDispositionFilter.this.contentDispositionExcludedPaths.contains(resourcePath)) {
                    if (ContentDispositionFilter.this.enableContentDispositionAllPaths) {
                        this.setContentDisposition(this.resource);
                    } else {
                        boolean contentDispositionAdded = false;
                        if (ContentDispositionFilter.this.contentDispositionPaths.contains(resourcePath)) {
                            if (ContentDispositionFilter.this.contentTypesMapping.containsKey(resourcePath)) {
                                Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(resourcePath);
                                if (!exceptions.contains(type)) {
                                    contentDispositionAdded = this.setContentDisposition(this.resource);
                                }
                            } else {
                                contentDispositionAdded = this.setContentDisposition(this.resource);
                            }
                        }
                        if (!contentDispositionAdded) {
                            for (String path : ContentDispositionFilter.this.contentDispositionPathsPfx) {
                                if (!resourcePath.startsWith(path)) continue;
                                if (ContentDispositionFilter.this.contentTypesMapping.containsKey(path)) {
                                    Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(path);
                                    if (exceptions.contains(type)) continue;
                                    this.setContentDisposition(this.resource);
                                    break;
                                }
                                this.setContentDisposition(this.resource);
                                break;
                            }
                        }
                    }
                }
            }
            super.setContentType(type);
        }

        private boolean setContentDisposition(Resource resource) {
            boolean contentDispositionAdded = false;
            if (!this.containsHeader(CONTENT_DISPOSTION) && this.isJcrData(resource)) {
                this.addHeader(CONTENT_DISPOSTION, CONTENT_DISPOSTION_ATTACHMENT);
                contentDispositionAdded = true;
            }
            return contentDispositionAdded;
        }

        private boolean isJcrData(Resource resource) {
            boolean jcrData = false;
            if (resource != null) {
                ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
                if (props != null && props.containsKey((Object)PROP_JCR_DATA)) {
                    jcrData = true;
                } else {
                    Resource jcrContent = resource.getChild(JCR_CONTENT_LEAF);
                    if (jcrContent != null && (props = (ValueMap)jcrContent.adaptTo(ValueMap.class)) != null && props.containsKey((Object)PROP_JCR_DATA)) {
                        jcrData = true;
                    }
                }
            }
            return jcrData;
        }
    }
}

