/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.security.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferrerFilter
implements Filter {
    private static final String USER_AGENT = "User-Agent";
    private static final String BROWSER_CLASS_MOZILLA = "Mozilla";
    private static final String BROWSER_CLASS_OPERA = "Opera";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEFAULT_ALLOW_EMPTY = true;
    private static final String PROP_ALLOW_EMPTY = "allow.empty";
    private static final String PROP_HOSTS = "allow.hosts";
    private static final String PROP_METHODS = "filter.methods";
    private boolean allowEmpty;
    private URL[] allowedReferrers;
    private String[] filterMethods;
    private ServiceRegistration configPrinterRegistration;

    private Set<String> getDefaultAllowedReferrers() {
        HashSet<String> referrers = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                this.logger.info("Adding Allowed referers for Interface:" + iface.getDisplayName());
                Enumeration<InetAddress> ias = iface.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress ia = ias.nextElement();
                    String address = ia.getHostAddress().trim().toLowerCase();
                    if (ia instanceof Inet4Address) {
                        referrers.add("http://" + address + ":0");
                        referrers.add("https://" + address + ":0");
                    }
                    if (!(ia instanceof Inet6Address)) continue;
                    referrers.add("http://[" + address + "]" + ":0");
                    referrers.add("https://[" + address + "]" + ":0");
                }
            }
        }
        catch (SocketException se) {
            this.logger.error("Unable to detect network interfaces", (Throwable)se);
        }
        referrers.add("http://localhost:0");
        referrers.add("http://127.0.0.1:0");
        referrers.add("http://[::1]:0");
        referrers.add("https://localhost:0");
        referrers.add("https://127.0.0.1:0");
        referrers.add("https://[::1]:0");
        return referrers;
    }

    private void add(List<URL> urls, String ref) {
        try {
            URL u = new URL(ref);
            urls.add(u);
        }
        catch (MalformedURLException mue) {
            this.logger.warn("Unable to create URL from " + ref + " : " + mue.getMessage());
        }
    }

    private URL[] createReferrerUrls(Set<String> referrers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String ref : referrers) {
            int pos = ref.indexOf("://");
            if (pos != -1) {
                this.add(urls, ref);
                continue;
            }
            this.add(urls, "http://" + ref + ":0");
            this.add(urls, "https://" + ref + ":0");
        }
        return urls.toArray(new URL[urls.size()]);
    }

    protected void activate(ComponentContext ctx) {
        this.allowEmpty = PropertiesUtil.toBoolean(ctx.getProperties().get(PROP_ALLOW_EMPTY), true);
        String[] allowHosts = PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_HOSTS));
        if (allowHosts != null) {
            if (allowHosts.length == 0) {
                allowHosts = null;
            } else if (allowHosts.length == 1 && allowHosts[0].trim().length() == 0) {
                allowHosts = null;
            }
        }
        Set<String> allowedReferrers = this.getDefaultAllowedReferrers();
        if (allowHosts != null) {
            for (String host : allowHosts) {
                allowedReferrers.add(host);
            }
        }
        this.allowedReferrers = this.createReferrerUrls(allowedReferrers);
        this.filterMethods = PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_METHODS));
        if (this.filterMethods != null && this.filterMethods.length == 1 && (this.filterMethods[0] == null || this.filterMethods[0].trim().length() == 0)) {
            this.filterMethods = null;
        }
        if (this.filterMethods != null) {
            for (int i = 0; i < this.filterMethods.length; ++i) {
                this.filterMethods[i] = this.filterMethods[i].toUpperCase();
            }
        }
        this.configPrinterRegistration = this.registerConfigPrinter(ctx.getBundleContext());
    }

    protected void deactivate() {
        this.configPrinterRegistration.unregister();
    }

    private ServiceRegistration registerConfigPrinter(BundleContext bundleContext) {
        ConfigurationPrinter cfgPrinter = new ConfigurationPrinter();
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Referrer Filter Configuration Printer");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)serviceProps).put("felix.webconsole.label", "slingreferrerfilter");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Referrer Filter");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        return bundleContext.registerService(Object.class.getName(), (Object)cfgPrinter, serviceProps);
    }

    private boolean isModification(HttpServletRequest req) {
        String method = req.getMethod();
        if (this.filterMethods != null) {
            for (String m : this.filterMethods) {
                if (!m.equals(method)) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request;
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse && this.isBrowserRequest(request = (HttpServletRequest)req) && this.isModification(request) && !this.isValidRequest(request)) {
            HttpServletResponse response = (HttpServletResponse)res;
            response.sendError(403);
            return;
        }
        chain.doFilter(req, res);
    }

    HostInfo getHost(String referrer) {
        int startPos = referrer.indexOf("://") + 3;
        if (startPos == 2) {
            return null;
        }
        HostInfo info = new HostInfo();
        info.scheme = referrer.substring(0, startPos - 3);
        int paramStart = referrer.indexOf(63);
        String hostAndPath = paramStart == -1 ? referrer : referrer.substring(0, paramStart);
        int endPos = hostAndPath.indexOf(47, startPos);
        String hostPart = endPos == -1 ? hostAndPath.substring(startPos) : hostAndPath.substring(startPos, endPos);
        int hostNameStart = hostPart.indexOf(64) + 1;
        int hostNameEnd = hostPart.lastIndexOf(58);
        if (hostNameEnd < hostNameStart) {
            info.host = hostPart.substring(hostNameStart);
            if (info.scheme.equals("http")) {
                info.port = 80;
            } else if (info.scheme.equals("https")) {
                info.port = 443;
            }
        } else {
            info.host = hostPart.substring(hostNameStart, hostNameEnd);
            info.port = Integer.valueOf(hostPart.substring(hostNameEnd + 1));
        }
        return info;
    }

    boolean isValidRequest(HttpServletRequest request) {
        String referrer = request.getHeader("referer");
        if (referrer == null || referrer.trim().length() == 0) {
            if (!this.allowEmpty) {
                this.logger.info("Rejected empty referrer header for {} request to {}", (Object)request.getMethod(), (Object)request.getRequestURI());
            }
            return this.allowEmpty;
        }
        if (referrer.indexOf(":/") == -1) {
            return true;
        }
        if (referrer.startsWith("app:/")) {
            return true;
        }
        HostInfo info = this.getHost(referrer);
        if (info == null) {
            this.logger.info("Rejected illegal referrer header for {} request to {} : {}", new Object[]{request.getMethod(), request.getRequestURI(), referrer});
            return false;
        }
        if (info.host.equals(request.getServerName())) {
            return true;
        }
        boolean valid = false;
        for (URL ref : this.allowedReferrers) {
            if (!info.host.equals(ref.getHost()) || !info.scheme.equals(ref.getProtocol()) || ref.getPort() != 0 && info.port != ref.getPort()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            this.logger.info("Rejected referrer header for {} request to {} : {}", new Object[]{request.getMethod(), request.getRequestURI(), referrer});
        }
        return valid;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    private boolean isBrowserRequest(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        return userAgent != null && (userAgent.contains(BROWSER_CLASS_MOZILLA) || userAgent.contains(BROWSER_CLASS_OPERA));
    }

    public class ConfigurationPrinter {
        public void printConfiguration(PrintWriter pw) {
            pw.println("Current Apache Sling Referrer Filter Allowed Referrers:");
            pw.println();
            for (URL url : ReferrerFilter.this.allowedReferrers) {
                pw.println(url.toString());
            }
        }
    }

    static final class HostInfo {
        public String host;
        public String scheme;
        public int port;

        HostInfo() {
        }
    }
}

