/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, description="Request filter adding Content Disposition attachment for certain paths/content types", label=" Apache Sling Content Disposition Filter")
@Service(value={Filter.class})
@Properties(value={@Property(name="sling.filter.scope", value={"request"}, propertyPrivate=true), @Property(name="service.ranking", intValue={-25000}, propertyPrivate=true)})
public class ContentDispositionFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Property(label="Content Disposition Paths", description="These paths are filtered by the filter. Each entry is of the form 'path [ \":\" CSV of excluded content types ]'. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY, value={""})
    private static final String PROP_CONTENT_DISPOSTION_PATHS = "sling.content.disposition.paths";
    Set<String> contentDispositionPaths;
    private String[] contentDispositionPathsPfx;
    private Map<String, Set<String>> contentTypesMapping;

    @Activate
    private void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        String[] contentDispostionProps = PropertiesUtil.toStringArray(props.get(PROP_CONTENT_DISPOSTION_PATHS));
        HashSet paths = new HashSet();
        ArrayList<String> pfxs = new ArrayList<String>();
        HashMap<String, Set<String>> contentTypesMap = new HashMap<String, Set<String>>();
        for (String path : contentDispostionProps) {
            if ((path = path.trim()).length() <= 0) continue;
            int idx = path.indexOf(42);
            int colonIdx = path.indexOf(":");
            if (colonIdx > -1 && colonIdx < idx) {
                this.logger.info("':' in paths is not allowed.");
                continue;
            }
            String p = null;
            if (idx >= 0) {
                if (idx > 0) {
                    p = path.substring(0, idx);
                    pfxs.add(p);
                } else {
                    this.logger.info("catch-all wildcard for paths not allowed.");
                }
            } else {
                p = colonIdx > -1 ? path.substring(0, colonIdx) : path;
                paths.add(p);
            }
            if (colonIdx == -1 || p == null) continue;
            Set<String> contentTypes = ContentDispositionFilter.getContentTypes(path.substring(colonIdx + 1));
            contentTypesMap.put(p, contentTypes);
        }
        this.contentDispositionPaths = paths.isEmpty() ? Collections.emptySet() : paths;
        this.contentDispositionPathsPfx = pfxs.toArray(new String[pfxs.size()]);
        this.contentTypesMapping = contentTypesMap.isEmpty() ? Collections.emptyMap() : contentTypesMap;
        this.logger.info("Initialized. content disposition paths: {}, content disposition paths-pfx {}", new Object[]{this.contentDispositionPaths, this.contentDispositionPathsPfx});
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        RewriterResponse rewriterResponse = new RewriterResponse(slingRequest, slingResponse);
        chain.doFilter(request, (ServletResponse)rewriterResponse);
    }

    private static Set<String> getContentTypes(String contentTypes) {
        HashSet<String> contentTypesSet = new HashSet<String>();
        if (contentTypes != null && contentTypes.length() > 0) {
            String[] contentTypesArray;
            for (String contentType : contentTypesArray = contentTypes.split(",")) {
                contentTypesSet.add(contentType);
            }
        }
        return contentTypesSet;
    }

    protected class RewriterResponse
    extends SlingHttpServletResponseWrapper {
        private static final String CONTENT_DISPOSTION = "Content-Disposition";
        private static final String CONTENT_DISPOSTION_ATTACHMENT = "attachment";
        private final SlingHttpServletRequest request;

        public RewriterResponse(SlingHttpServletRequest request, SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
            this.request = request;
        }

        public void setContentType(String type) {
            String pathInfo = this.request.getPathInfo();
            if (ContentDispositionFilter.this.contentDispositionPaths.contains(pathInfo)) {
                if (ContentDispositionFilter.this.contentTypesMapping.containsKey(pathInfo)) {
                    Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(pathInfo);
                    if (!exceptions.contains(type)) {
                        this.setContentDisposition();
                    }
                } else {
                    this.setContentDisposition();
                }
            }
            for (String path : ContentDispositionFilter.this.contentDispositionPathsPfx) {
                if (!this.request.getPathInfo().startsWith(path)) continue;
                if (ContentDispositionFilter.this.contentTypesMapping.containsKey(path)) {
                    Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(path);
                    if (exceptions.contains(type)) continue;
                    this.setContentDisposition();
                    break;
                }
                this.setContentDisposition();
                break;
            }
            super.setContentType(type);
        }

        private void setContentDisposition() {
            this.addHeader(CONTENT_DISPOSTION, CONTENT_DISPOSTION_ATTACHMENT);
        }
    }
}

