/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.utils;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.engine.ResourceResolution;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ScriptDependencyResolver.class}, property={"resource.paths=.", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
public class ScriptDependencyResolver
implements ResourceChangeListener,
ExternalResourceChangeListener,
BundleListener {
    public static final String BUNDLED_SCRIPTS_REQUIREMENT = "osgi.extender;filter:=\"(&(osgi.extender=sling.scripting)(version>=1.0.0)(!(version>=2.0.0)))\"";
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Map<String, String> resolutionCache = new Cache(0);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private ServiceRegistration<ResourceChangeListener> resourceChangeListenerServiceRegistration;
    private boolean cacheEnabled = false;
    private static final String NOT_FOUND_MARKER = "#NOT_FOUND#";

    @Activate
    private void activate(ComponentContext componentContext) {
        int cacheSize = this.sightlyEngineConfiguration.getScriptResolutionCacheSize();
        if (cacheSize < 1024) {
            this.cacheEnabled = false;
            this.resolutionCache = new Cache(0);
        } else {
            this.cacheEnabled = true;
            this.resolutionCache = new Cache(cacheSize);
        }
        if (this.cacheEnabled) {
            componentContext.getBundleContext().addBundleListener((BundleListener)this);
            Hashtable<String, Object> resourceChangeListenerProperties = new Hashtable<String, Object>();
            ((Dictionary)resourceChangeListenerProperties).put("resource.paths", ".");
            ((Dictionary)resourceChangeListenerProperties).put("resource.change.types", new String[]{"ADDED", "CHANGED", "REMOVED"});
            this.resourceChangeListenerServiceRegistration = componentContext.getBundleContext().registerService(ResourceChangeListener.class, (Object)this, resourceChangeListenerProperties);
        }
    }

    @Deactivate
    private void deactivate(ComponentContext componentContext) {
        if (this.resourceChangeListenerServiceRegistration != null) {
            this.resourceChangeListenerServiceRegistration.unregister();
        }
        componentContext.getBundleContext().removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resolveScript(RenderContext renderContext, String scriptIdentifier) {
        SlingHttpServletRequest request = BindingsUtils.getRequest(renderContext.getBindings());
        if (!this.cacheEnabled) {
            return this.internalResolveScript(request, renderContext, scriptIdentifier);
        }
        this.readLock.lock();
        try {
            String cacheKey = request.getResource().getResourceType() + ":" + scriptIdentifier;
            Resource result = null;
            if (!this.resolutionCache.containsKey(cacheKey)) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (!this.resolutionCache.containsKey(cacheKey)) {
                        result = this.internalResolveScript(request, renderContext, scriptIdentifier);
                        if (result != null) {
                            this.resolutionCache.put(cacheKey, result.getPath());
                        } else {
                            this.resolutionCache.put(cacheKey, NOT_FOUND_MARKER);
                        }
                    }
                    this.readLock.lock();
                }
                finally {
                    this.writeLock.unlock();
                }
            } else {
                String scriptPath = this.resolutionCache.get(cacheKey);
                if (!scriptPath.equals(NOT_FOUND_MARKER)) {
                    result = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver().getResource(scriptPath);
                }
            }
            Resource resource = result;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Nullable
    private Resource internalResolveScript(SlingHttpServletRequest request, RenderContext renderContext, String scriptIdentifier) {
        SlingScriptHelper sling;
        Resource caller = ResourceResolution.getResourceForRequest(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), request);
        Resource result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        if (result == null && (sling = BindingsUtils.getHelper(renderContext.getBindings())) != null) {
            caller = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver().getResource(sling.getScript().getScriptResource().getPath());
            result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        }
        return result;
    }

    public void onChange(@NotNull List<ResourceChange> changes) {
        this.writeLock.lock();
        try {
            this.resolutionCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Dictionary bundleHeaders = event.getBundle().getHeaders();
        String requireCapabilityHeader = (String)bundleHeaders.get("Require-Capability");
        if (StringUtils.isNotEmpty((CharSequence)requireCapabilityHeader) && requireCapabilityHeader.contains(BUNDLED_SCRIPTS_REQUIREMENT)) {
            this.writeLock.lock();
            try {
                this.resolutionCache.clear();
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static class Cache
    extends LinkedHashMap<String, String> {
        private final int cacheSize;

        public Cache(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > this.cacheSize;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Cache) {
                Cache other = (Cache)o;
                return super.equals(o) && this.cacheSize == other.cacheSize;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.cacheSize);
        }
    }
}

