/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.extension.use.ResourceUseProvider"}, property={"service.ranking:Integer=-10"})
public class ResourceUseProvider
implements UseProvider {
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        SlingHttpServletRequest request = BindingsUtils.getRequest(globalBindings);
        String path = this.normalizePath(request, identifier);
        try {
            Resource resource = request.getResourceResolver().getResource(path);
            if (resource != null && !ResourceUtil.isNonExistingResource((Resource)resource)) {
                return ProviderOutcome.success((Object)resource);
            }
        }
        catch (Exception e) {
            return ProviderOutcome.failure((Throwable)e);
        }
        return ProviderOutcome.failure();
    }

    private String normalizePath(SlingHttpServletRequest request, String path) {
        if (!path.startsWith("/")) {
            path = request.getResource().getPath() + "/" + path;
        }
        return ResourceUtil.normalize((String)path);
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default -10;
    }
}

