/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

class RuntimeExtensionReference
implements Comparable<RuntimeExtensionReference> {
    private final int priority;
    private final String name;
    private ServiceReference<RuntimeExtension> serviceReference;
    private RuntimeExtension runtimeExtension;

    RuntimeExtensionReference(ServiceReference<RuntimeExtension> serviceReference, RuntimeExtension runtimeExtension) {
        this.serviceReference = serviceReference;
        this.runtimeExtension = runtimeExtension;
        this.priority = PropertiesUtil.toInteger((Object)serviceReference.getProperty("service.ranking"), (int)0);
        this.name = PropertiesUtil.toString((Object)serviceReference.getProperty("org.apache.sling.scripting.sightly.extension.name"), (String)"");
    }

    @Override
    public int compareTo(@NotNull RuntimeExtensionReference other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.name.equals(other.name)) {
            return this.priority - other.priority;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeExtensionReference) {
            RuntimeExtensionReference other = (RuntimeExtensionReference)obj;
            return this.serviceReference.equals(other.serviceReference);
        }
        return false;
    }

    public int hashCode() {
        return this.serviceReference.hashCode();
    }

    public String getName() {
        return this.name;
    }

    ServiceReference<RuntimeExtension> getServiceReference() {
        return this.serviceReference;
    }

    synchronized RuntimeExtension getService() {
        return this.runtimeExtension;
    }
}

