/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.engine;

import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;

public final class ResourceResolution {
    private static final int RECURSION_LIMIT = 100;

    public static Resource getResourceFromSearchPath(Resource base, String path) {
        Resource resource;
        if (base == null || path == null) {
            return null;
        }
        if (path.startsWith("/") && (resource = ResourceResolution.getScriptResource(base.getResourceResolver(), path)) != null) {
            return ResourceResolution.searchPathChecked(resource);
        }
        Resource internalBase = "nt:file".equals(base.getResourceType()) || base.adaptTo(Servlet.class) != null ? base.getParent() : base;
        return ResourceResolution.resolveComponentInternal(internalBase, path);
    }

    public static Resource getResourceForRequest(ResourceResolver resolver, SlingHttpServletRequest request) {
        if (resolver == null || request == null) {
            return null;
        }
        String resourceType = request.getResource().getResourceType();
        if (StringUtils.isNotEmpty((CharSequence)resourceType)) {
            return ResourceResolution.getScriptResource(resolver, resourceType);
        }
        return null;
    }

    private static Resource resolveComponentInternal(Resource base, String path) {
        if (base == null || path == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        Resource resource = ResourceResolution.recursiveResolution(base, path);
        if (resource == null) {
            resource = ResourceResolution.locateInSearchPath(base.getResourceResolver(), path);
        }
        return resource != null ? ResourceResolution.searchPathChecked(resource) : null;
    }

    private static Resource recursiveResolution(Resource base, String path) {
        ResourceResolver resolver = base.getResourceResolver();
        for (int iteration = 0; iteration < 100; ++iteration) {
            Resource resource = null;
            if (path.startsWith("/")) {
                resource = ResourceResolution.getScriptResource(resolver, path);
            } else {
                String normalizedPath = ResourceUtil.normalize((String)(base.getPath() + "/" + path));
                if (normalizedPath != null) {
                    resource = ResourceResolution.getScriptResource(resolver, normalizedPath);
                }
            }
            if (resource != null) {
                return resource;
            }
            if ((base = ResourceResolution.findSuperComponent(base)) != null) continue;
            return null;
        }
        throw new IllegalStateException("Searching for resource in component chain took more than 100 steps");
    }

    private static Resource locateInSearchPath(ResourceResolver resourceResolver, String path) {
        for (String searchPath : resourceResolver.getSearchPath()) {
            Resource resource;
            String fullPath = ResourceUtil.normalize((String)(searchPath + path));
            if (fullPath == null || (resource = resourceResolver.getResource(fullPath)) == null || !resource.getPath().startsWith(searchPath)) continue;
            return resource;
        }
        return null;
    }

    private static boolean isInSearchPath(Resource resource) {
        String resourcePath = resource.getPath();
        ResourceResolver resolver = resource.getResourceResolver();
        for (String path : resolver.getSearchPath()) {
            if (!resourcePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private static Resource findSuperComponent(Resource base) {
        ResourceResolver resolver = base.getResourceResolver();
        String superType = resolver.getParentResourceType(base);
        if (superType == null) {
            return null;
        }
        return ResourceResolution.getScriptResource(resolver, superType);
    }

    private static Resource searchPathChecked(Resource resource) {
        if (!ResourceResolution.isInSearchPath(resource)) {
            throw new UnsupportedOperationException("Access to resource " + resource.getPath() + " is denied, since the resource does not reside on the search path");
        }
        return resource;
    }

    private static Resource getScriptResource(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        if (path.startsWith("/")) {
            return resourceResolver.getResource(path);
        }
        for (String searchPath : resourceResolver.getSearchPath()) {
            Resource resource;
            String resourcePath = ResourceUtil.normalize((String)(searchPath + path));
            if (resourcePath == null || (resource = resourceResolver.getResource(resourcePath)) == null) continue;
            return resource;
        }
        return null;
    }
}

