/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;

public final class Expression {
    private final Map<String, ExpressionNode> options;
    private final ExpressionNode root;
    private final String rawText;

    public Expression(ExpressionNode root) {
        this(root, Collections.emptyMap());
    }

    public Expression(ExpressionNode root, Map<String, ExpressionNode> options) {
        this(root, options, null);
    }

    public Expression(ExpressionNode root, Map<String, ExpressionNode> options, String rawText) {
        this.options = new HashMap<String, ExpressionNode>(options);
        if (root instanceof BinaryOperation) {
            BinaryOperation binaryOperation = (BinaryOperation)root;
            this.root = binaryOperation.withParentExpression(this);
        } else {
            this.root = root;
        }
        this.rawText = rawText;
    }

    public Map<String, ExpressionNode> getOptions() {
        return this.options;
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public ExpressionNode removeOption(String option) {
        return this.options.remove(option);
    }

    public Expression withNode(ExpressionNode node) {
        return new Expression(node, this.options);
    }

    public Expression withRawText(String rawText) {
        return new Expression(this.root, this.options, rawText);
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean containsOption(String name) {
        return this.options.containsKey(name);
    }

    public String toString() {
        return "Expression{options=" + this.getOptions() + ", root=" + this.root + '}';
    }
}

