/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.stateful;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.security.AccessSecurityException;
import org.apache.sling.api.security.ResourceAccessSecurity;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.helper.AbstractIterator;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverImpl.class);
    public static final AuthenticatedResourceProvider UNAUTHENTICATED_PROVIDER = new AuthenticatedResourceProvider(null, false, null, null);
    private final ResourceProviderHandler providerHandler;
    private final ResolveContext<Object> resolveContext;
    private final ResourceAccessSecurityTracker tracker;
    private final boolean useRAS;

    public AuthenticatedResourceProvider(@NotNull ResourceProviderHandler providerHandler, boolean useRAS, @NotNull ResolveContext<Object> resolveContext, @NotNull ResourceAccessSecurityTracker tracker) {
        this.providerHandler = providerHandler;
        this.resolveContext = resolveContext;
        this.tracker = tracker;
        this.useRAS = useRAS;
    }

    @NotNull
    public ResolveContext<Object> getResolveContext() {
        return this.resolveContext;
    }

    public void refresh() {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            rp.refresh(this.resolveContext);
        }
    }

    public boolean isLive() {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.isLive(this.resolveContext);
        }
        return false;
    }

    public Resource getParent(Resource child) {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return this.wrapResource(rp.getParent(this.resolveContext, child));
        }
        return null;
    }

    public Resource getResource(String path, Resource parent, final Map<String, String> parameters) {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp == null) {
            return null;
        }
        ResourceContext resourceContext = parameters != null ? new ResourceContext(){

            public Map<String, String> getResolveParameters() {
                return parameters;
            }
        } : ResourceContext.EMPTY_CONTEXT;
        return this.wrapResource(rp.getResource(this.resolveContext, path, resourceContext, parent));
    }

    public Iterator<Resource> listChildren(Resource parent) {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return this.wrapIterator(rp.listChildren(this.resolveContext, parent));
        }
        return null;
    }

    public void getAttributeNames(Set<String> attributeNames) {
        Collection rpAttributeNames;
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null && (rpAttributeNames = rp.getAttributeNames(this.resolveContext)) != null) {
            attributeNames.addAll(rpAttributeNames);
        }
    }

    public Object getAttribute(String name) {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.getAttribute(this.resolveContext, name);
        }
        return null;
    }

    public Resource create(ResourceResolver resolver, String path, Map<String, Object> properties) throws PersistenceException {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null && this.canCreate(resolver, path)) {
            return rp.create(this.resolveContext, path, properties);
        }
        return null;
    }

    public void delete(Resource resource) throws PersistenceException {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp == null || !this.canDelete(resource)) {
            throw new PersistenceException("Unable to delete resource " + resource.getPath());
        }
        rp.delete(this.resolveContext, resource);
    }

    public void revert() {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            rp.revert(this.resolveContext);
        }
    }

    public void commit() throws PersistenceException {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            rp.commit(this.resolveContext);
        }
    }

    public boolean hasChanges() {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.hasChanges(this.resolveContext);
        }
        return false;
    }

    private QueryLanguageProvider<Object> getQueryLanguageProvider() {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.getQueryLanguageProvider();
        }
        return null;
    }

    public String[] getSupportedLanguages() {
        QueryLanguageProvider<Object> jcrQueryProvider = this.getQueryLanguageProvider();
        if (jcrQueryProvider == null) {
            return null;
        }
        return jcrQueryProvider.getSupportedLanguages(this.resolveContext);
    }

    public Iterator<Resource> findResources(String query, String language) {
        QueryLanguageProvider<Object> jcrQueryProvider = this.getQueryLanguageProvider();
        if (jcrQueryProvider == null) {
            return null;
        }
        return this.wrapIterator(jcrQueryProvider.findResources(this.resolveContext, this.transformQuery(query, language), language));
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) {
        QueryLanguageProvider<Object> jcrQueryProvider = this.getQueryLanguageProvider();
        if (jcrQueryProvider == null) {
            return null;
        }
        return jcrQueryProvider.queryResources(this.resolveContext, this.transformQuery(query, language), language);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return (AdapterType)rp.adaptTo(this.resolveContext, type);
        }
        return null;
    }

    public boolean copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.copy(this.resolveContext, srcAbsPath, destAbsPath);
        }
        return false;
    }

    public boolean move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        ResourceProvider<Object> rp = this.providerHandler.getResourceProvider();
        if (rp != null) {
            return rp.move(this.resolveContext, srcAbsPath, destAbsPath);
        }
        return false;
    }

    private boolean canCreate(ResourceResolver resolver, String path) {
        ResourceAccessSecurity security;
        boolean allowed = true;
        if (this.useRAS) {
            security = this.tracker.getProviderResourceAccessSecurity();
            allowed = security != null ? security.canCreate(path, resolver) : false;
        }
        if (allowed && (security = this.tracker.getApplicationResourceAccessSecurity()) != null) {
            allowed = security.canCreate(path, resolver);
        }
        return allowed;
    }

    private boolean canDelete(Resource resource) {
        ResourceAccessSecurity security;
        boolean allowed = true;
        if (this.useRAS) {
            security = this.tracker.getProviderResourceAccessSecurity();
            allowed = security != null ? security.canDelete(resource) : false;
        }
        if (allowed && (security = this.tracker.getApplicationResourceAccessSecurity()) != null) {
            allowed = security.canDelete(resource);
        }
        return allowed;
    }

    private String transformQuery(String query, String language) {
        ResourceAccessSecurity resourceAccessSecurity;
        String returnValue = query;
        if (this.useRAS && (resourceAccessSecurity = this.tracker.getProviderResourceAccessSecurity()) != null) {
            try {
                returnValue = resourceAccessSecurity.transformQuery(returnValue, language, this.resolveContext.getResourceResolver());
            }
            catch (AccessSecurityException e) {
                logger.error("AccessSecurityException occurred while trying to transform the query {} (language {}).", (Object)new Object[]{query, language}, (Object)e);
            }
        }
        if ((resourceAccessSecurity = this.tracker.getApplicationResourceAccessSecurity()) != null) {
            try {
                returnValue = resourceAccessSecurity.transformQuery(returnValue, language, this.resolveContext.getResourceResolver());
            }
            catch (AccessSecurityException e) {
                logger.error("AccessSecurityException occurred while trying to transform the query {} (language {}).", (Object)new Object[]{query, language}, (Object)e);
            }
        }
        return returnValue;
    }

    @Nullable
    private Resource wrapResource(@Nullable Resource rsrc) {
        ResourceAccessSecurity resourceAccessSecurity;
        Resource returnValue = null;
        if (this.useRAS && rsrc != null) {
            resourceAccessSecurity = this.tracker.getProviderResourceAccessSecurity();
            if (resourceAccessSecurity != null) {
                returnValue = resourceAccessSecurity.getReadableResource(rsrc);
            }
        } else {
            returnValue = rsrc;
        }
        if (returnValue != null && (resourceAccessSecurity = this.tracker.getApplicationResourceAccessSecurity()) != null) {
            returnValue = resourceAccessSecurity.getReadableResource(returnValue);
        }
        return returnValue;
    }

    private Iterator<Resource> wrapIterator(Iterator<Resource> iterator) {
        if (iterator == null) {
            return iterator;
        }
        return new SecureIterator(iterator);
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "# rp: " + this.providerHandler.getResourceProvider() + "]";
    }

    private class SecureIterator
    extends AbstractIterator<Resource> {
        private final Iterator<Resource> iterator;

        public SecureIterator(Iterator<Resource> iterator) {
            this.iterator = iterator;
        }

        @Override
        protected Resource seek() {
            while (this.iterator.hasNext()) {
                Resource resource = AuthenticatedResourceProvider.this.wrapResource(this.iterator.next());
                if (resource == null) continue;
                return resource;
            }
            return null;
        }
    }
}

