/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.stateful;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.stateful.ProviderManager;
import org.apache.sling.resourceresolver.impl.providers.tree.Node;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class BasicResolveContext<T>
implements ResolveContext<T> {
    private final ResourceResolver resolver;
    private final ProviderManager resolveContextManager;
    private final ResourceResolverControl control;
    private final T providerState;
    private final String parentPath;

    public BasicResolveContext(@Nonnull ResourceResolver resolver, @Nonnull ProviderManager resolveContextManager, @Nonnull ResourceResolverControl control, @CheckForNull T providerState, @Nonnull String parentPath) {
        this.resolver = resolver;
        this.resolveContextManager = resolveContextManager;
        this.parentPath = parentPath;
        this.providerState = providerState;
        this.control = control;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public T getProviderState() {
        return this.providerState;
    }

    public ResolveContext<?> getParentResolveContext() {
        Object[] providerAndContext = this.getParentProviderAndContext();
        return (ResolveContext)(providerAndContext != null ? providerAndContext[1] : null);
    }

    public ResourceProvider<?> getParentResourceProvider() {
        Object[] providerAndContext = this.getParentProviderAndContext();
        return (ResourceProvider)(providerAndContext != null ? providerAndContext[0] : null);
    }

    private Object[] getParentProviderAndContext() {
        Object[] objectArray;
        ResourceProvider<Object> parentProvider = null;
        ResolveContext<Object> parentResolveContext = null;
        if (this.parentPath != null) {
            String path = this.parentPath;
            while (path != null && parentProvider == null) {
                Node<ResourceProviderHandler> node = this.control.getResourceProviderStorage().getTree().getBestMatchingNode(path);
                if (node != null) {
                    ResourceProviderHandler handler = node.getValue();
                    try {
                        parentResolveContext = this.resolveContextManager.getOrCreateResolveContext(handler, this.control);
                        if (parentResolveContext != null) {
                            parentProvider = handler.getResourceProvider();
                        }
                    }
                    catch (LoginException loginException) {
                        // empty catch block
                    }
                    if (parentProvider != null) continue;
                    parentResolveContext = null;
                    path = ResourceUtil.getParent((String)path);
                    continue;
                }
                path = null;
            }
        }
        if (parentProvider != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = parentProvider;
            objectArray = objectArray2;
            objectArray2[1] = parentResolveContext;
        } else {
            objectArray = null;
        }
        return objectArray;
    }
}

