/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.resourceresolver.impl.observation.BasicObservationReporter;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerInfo;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChangeListenerWhiteboard
implements ResourceProviderTracker.ObservationReporterGenerator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ServiceReference<ResourceChangeListener>, ResourceChangeListenerInfo> listeners = new ConcurrentHashMap<ServiceReference<ResourceChangeListener>, ResourceChangeListenerInfo>();
    private volatile ResourceProviderTracker resourceProviderTracker;
    private volatile ServiceTracker<ResourceChangeListener, ServiceReference<ResourceChangeListener>> tracker;
    private volatile String[] searchPath;
    private static final ObservationReporter EMPTY_REPORTER = new ObservationReporter(){

        public void reportChanges(Iterable<ResourceChange> changes, boolean distribute) {
        }

        public void reportChanges(ObserverConfiguration config, Iterable<ResourceChange> changes, boolean distribute) {
        }

        public List<ObserverConfiguration> getObserverConfigurations() {
            return Collections.emptyList();
        }
    };
    private static final ResourceProviderTracker.ObservationReporterGenerator NOP_GENERATOR = new ResourceProviderTracker.ObservationReporterGenerator(){

        @Override
        public ObservationReporter create(Path path, PathSet excludes) {
            return EMPTY_REPORTER;
        }

        @Override
        public ObservationReporter createProviderReporter() {
            return EMPTY_REPORTER;
        }
    };

    public void activate(final BundleContext bundleContext, ResourceProviderTracker resourceProviderTracker, final String[] searchPath) {
        this.searchPath = searchPath;
        this.resourceProviderTracker = resourceProviderTracker;
        this.resourceProviderTracker.setObservationReporterGenerator(this);
        this.tracker = new ServiceTracker(bundleContext, ResourceChangeListener.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ResourceChangeListener, ServiceReference<ResourceChangeListener>>(){

            public void removedService(ServiceReference<ResourceChangeListener> reference, ServiceReference<ResourceChangeListener> service) {
                ResourceChangeListenerInfo info = (ResourceChangeListenerInfo)ResourceChangeListenerWhiteboard.this.listeners.remove(reference);
                if (info != null) {
                    ResourceChangeListenerWhiteboard.this.updateProviderTracker();
                }
            }

            public void modifiedService(ServiceReference<ResourceChangeListener> reference, ServiceReference<ResourceChangeListener> service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public ServiceReference<ResourceChangeListener> addingService(ServiceReference<ResourceChangeListener> reference) {
                ResourceChangeListenerInfo info = new ResourceChangeListenerInfo(reference, searchPath);
                if (info.isValid()) {
                    ResourceChangeListener listener = (ResourceChangeListener)bundleContext.getService(reference);
                    if (listener != null) {
                        info.setListener(listener);
                        ResourceChangeListenerWhiteboard.this.listeners.put(reference, info);
                        ResourceChangeListenerWhiteboard.this.updateProviderTracker();
                    }
                } else {
                    ResourceChangeListenerWhiteboard.this.logger.warn("Ignoring invalid resource change listenr {}", reference);
                }
                return reference;
            }
        });
        this.tracker.open();
    }

    public void deactivate() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.resourceProviderTracker.setObservationReporterGenerator(NOP_GENERATOR);
        this.resourceProviderTracker = null;
    }

    private void updateProviderTracker() {
        this.resourceProviderTracker.setObservationReporterGenerator(this);
    }

    @Override
    public ObservationReporter create(Path path, PathSet excludes) {
        return new BasicObservationReporter(this.searchPath, this.listeners.values(), path, excludes);
    }

    @Override
    public ObservationReporter createProviderReporter() {
        return new BasicObservationReporter(this.searchPath, this.listeners.values());
    }
}

