/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.legacy;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourceresolver.impl.legacy.LegacyResourceProviderAdapter;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class LegacyResourceProviderFactoryAdapter
extends ResourceProvider<LegacyResourceProviderAdapter> {
    private final ResourceProviderFactory rpFactory;
    private final String[] languages;
    private final boolean ownsRoot;

    public LegacyResourceProviderFactoryAdapter(ResourceProviderFactory rpFactory, String[] languages, boolean ownsRoot) {
        this.rpFactory = rpFactory;
        this.languages = languages;
        this.ownsRoot = ownsRoot;
    }

    @Nonnull
    public LegacyResourceProviderAdapter authenticate(@Nonnull Map<String, Object> authenticationInfo) throws LoginException {
        return new LegacyResourceProviderAdapter(this.rpFactory.getResourceProvider(authenticationInfo), this.languages, this.ownsRoot);
    }

    public void logout(@Nonnull LegacyResourceProviderAdapter state) {
        state.logout(null);
    }

    public Resource getResource(ResolveContext<LegacyResourceProviderAdapter> ctx, String path, ResourceContext resourceContext, Resource parent) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getResource(ctx, path, resourceContext, parent);
    }

    public Iterator<Resource> listChildren(ResolveContext<LegacyResourceProviderAdapter> ctx, Resource parent) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).listChildren(ctx, parent);
    }

    public void refresh(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).refresh(ctx);
    }

    @CheckForNull
    public QueryLanguageProvider<LegacyResourceProviderAdapter> getQueryLanguageProvider() {
        if (ArrayUtils.isEmpty((Object[])this.languages)) {
            return super.getQueryLanguageProvider();
        }
        return new JCRQueryProviderAdapter(this.languages);
    }

    public Collection<String> getAttributeNames(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getAttributeNames(ctx);
    }

    public Object getAttribute(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx, @Nonnull String name) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getAttribute(ctx, name);
    }

    public boolean isLive(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).isLive(ctx);
    }

    public Resource create(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).create(ctx, path, properties);
    }

    public void delete(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx, @Nonnull Resource resource) throws PersistenceException {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).delete(ctx, resource);
    }

    public void revert(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).revert(ctx);
    }

    public void commit(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) throws PersistenceException {
        ((LegacyResourceProviderAdapter)ctx.getProviderState()).commit(ctx);
    }

    public boolean hasChanges(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).hasChanges(ctx);
    }

    public <AdapterType> AdapterType adaptTo(@Nonnull ResolveContext<LegacyResourceProviderAdapter> ctx, @Nonnull Class<AdapterType> type) {
        return ((LegacyResourceProviderAdapter)ctx.getProviderState()).adaptTo(ctx, type);
    }

    private static class JCRQueryProviderAdapter
    implements QueryLanguageProvider<LegacyResourceProviderAdapter> {
        private final String[] languages;

        public JCRQueryProviderAdapter(String[] languages) {
            this.languages = languages;
        }

        public String[] getSupportedLanguages(ResolveContext<LegacyResourceProviderAdapter> ctx) {
            return this.languages;
        }

        public Iterator<Resource> findResources(ResolveContext<LegacyResourceProviderAdapter> ctx, String query, String language) {
            return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getQueryLanguageProvider().findResources(ctx, query, language);
        }

        public Iterator<ValueMap> queryResources(ResolveContext<LegacyResourceProviderAdapter> ctx, String query, String language) {
            return ((LegacyResourceProviderAdapter)ctx.getProviderState()).getQueryLanguageProvider().queryResources(ctx, query, language);
        }
    }
}

