/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;

public class ResourceChangeListenerInfo
implements Comparable<ResourceChangeListenerInfo> {
    private static final Set<ResourceChange.ChangeType> DEFAULT_CHANGE_RESOURCE_TYPES = EnumSet.of(ResourceChange.ChangeType.ADDED, ResourceChange.ChangeType.REMOVED, ResourceChange.ChangeType.CHANGED);
    private static final Set<ResourceChange.ChangeType> DEFAULT_CHANGE_PROVIDER_TYPES = EnumSet.of(ResourceChange.ChangeType.PROVIDER_ADDED, ResourceChange.ChangeType.PROVIDER_REMOVED);
    private final PathSet paths;
    private final Set<ResourceChange.ChangeType> resourceChangeTypes;
    private final Set<ResourceChange.ChangeType> providerChangeTypes;
    private final Set<String> propertyNamesHint;
    private final boolean valid;
    private volatile boolean external = false;
    private volatile ResourceChangeListener listener;

    public ResourceChangeListenerInfo(ServiceReference<ResourceChangeListener> ref, String[] searchPaths) {
        boolean configValid = true;
        HashSet<String> pathsSet = new HashSet<String>();
        String[] paths = PropertiesUtil.toStringArray((Object)ref.getProperty("resource.paths"), null);
        if (paths != null) {
            for (String p : paths) {
                boolean isGlobPattern = false;
                String normalisedPath = ResourceUtil.normalize((String)p);
                if (p.startsWith("glob:")) {
                    isGlobPattern = true;
                    normalisedPath = ResourceUtil.normalize((String)p.substring("glob:".length()));
                }
                if (!".".equals(p) && normalisedPath.isEmpty()) {
                    configValid = false;
                    continue;
                }
                if (normalisedPath.startsWith("/") && !isGlobPattern) {
                    pathsSet.add(normalisedPath);
                    continue;
                }
                if (normalisedPath.startsWith("/") && isGlobPattern) {
                    pathsSet.add("glob:" + normalisedPath);
                    continue;
                }
                for (String sp : searchPaths) {
                    if (p.equals(".")) {
                        pathsSet.add(sp);
                        continue;
                    }
                    if (isGlobPattern) {
                        pathsSet.add("glob:" + ResourceUtil.normalize((String)(sp + normalisedPath)));
                        continue;
                    }
                    pathsSet.add(ResourceUtil.normalize((String)(sp + normalisedPath)));
                }
            }
        }
        if (pathsSet.isEmpty()) {
            configValid = false;
        } else {
            Iterator iter = pathsSet.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                boolean remove = false;
                for (String p : pathsSet) {
                    if (p.length() <= path.length() || !path.startsWith(p + "/")) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                iter.remove();
            }
        }
        this.paths = PathSet.fromStringCollection(pathsSet);
        if (ref.getProperty("resource.change.types") != null) {
            HashSet<ResourceChange.ChangeType> rts = new HashSet<ResourceChange.ChangeType>();
            HashSet<ResourceChange.ChangeType> pts = new HashSet<ResourceChange.ChangeType>();
            for (String changeName : PropertiesUtil.toStringArray((Object)ref.getProperty("resource.change.types"))) {
                try {
                    ResourceChange.ChangeType ct = ResourceChange.ChangeType.valueOf((String)changeName);
                    if (ct.ordinal() < ResourceChange.ChangeType.PROVIDER_ADDED.ordinal()) {
                        rts.add(ct);
                        continue;
                    }
                    pts.add(ct);
                }
                catch (IllegalArgumentException iae) {
                    configValid = false;
                }
            }
            this.resourceChangeTypes = rts.isEmpty() ? Collections.emptySet() : (rts.size() == 3 ? DEFAULT_CHANGE_RESOURCE_TYPES : Collections.unmodifiableSet(rts));
            this.providerChangeTypes = pts.isEmpty() ? Collections.emptySet() : (pts.size() == 2 ? DEFAULT_CHANGE_PROVIDER_TYPES : Collections.unmodifiableSet(pts));
        } else {
            this.resourceChangeTypes = DEFAULT_CHANGE_RESOURCE_TYPES;
            this.providerChangeTypes = DEFAULT_CHANGE_PROVIDER_TYPES;
        }
        if (ref.getProperty("resource.property.names.hint") != null) {
            this.propertyNamesHint = new HashSet<String>();
            for (String val : PropertiesUtil.toStringArray((Object)ref.getProperty("resource.property.names.hint"))) {
                this.propertyNamesHint.add(val);
            }
        } else {
            this.propertyNamesHint = null;
        }
        this.valid = configValid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<ResourceChange.ChangeType> getResourceChangeTypes() {
        return this.resourceChangeTypes;
    }

    public Set<ResourceChange.ChangeType> getProviderChangeTypes() {
        return this.providerChangeTypes;
    }

    public PathSet getPaths() {
        return this.paths;
    }

    public Set<String> getPropertyNamesHint() {
        return this.propertyNamesHint;
    }

    public boolean isExternal() {
        return this.external;
    }

    public ResourceChangeListener getListener() {
        return this.listener;
    }

    public void setListener(ResourceChangeListener listener) {
        this.listener = listener;
        this.external = listener instanceof ExternalResourceChangeListener;
    }

    private int compareSet(Set<String> t, Set<String> o) {
        if (t == null && o == null) {
            return 0;
        }
        if (t == null) {
            return -1;
        }
        if (o == null) {
            return 1;
        }
        TreeSet<String> tPaths = new TreeSet<String>(t);
        TreeSet<String> oPaths = new TreeSet<String>(o);
        int result = tPaths.size() - oPaths.size();
        if (result == 0) {
            Iterator tPathsIter = tPaths.iterator();
            Iterator oPathsIter = oPaths.iterator();
            while (result == 0 && tPathsIter.hasNext()) {
                result = ((String)tPathsIter.next()).compareTo((String)oPathsIter.next());
            }
        }
        return result;
    }

    private int compareChangeTypes(Set<ResourceChange.ChangeType> t, Set<ResourceChange.ChangeType> o) {
        int result = t.size() - o.size();
        if (result == 0) {
            Iterator<ResourceChange.ChangeType> tIter = t.iterator();
            Iterator<ResourceChange.ChangeType> oIter = o.iterator();
            while (result == 0 && tIter.hasNext()) {
                result = tIter.next().compareTo((Enum)oIter.next());
            }
        }
        return result;
    }

    @Override
    public int compareTo(ResourceChangeListenerInfo o) {
        int result = this.compareSet(this.paths.toStringSet(), o.paths.toStringSet());
        if (result == 0 && (result = this.compareSet(this.propertyNamesHint, o.propertyNamesHint)) == 0 && (result = Boolean.valueOf(this.external).compareTo(o.external)) == 0 && (result = this.compareChangeTypes(this.resourceChangeTypes, o.resourceChangeTypes)) == 0) {
            result = this.compareChangeTypes(this.providerChangeTypes, o.providerChangeTypes);
        }
        return result;
    }

    public String toString() {
        return "ResourceChangeListenerInfo [paths=" + this.paths + ", resourceChangeTypes=" + this.resourceChangeTypes + ", providerChangeTypes=" + this.providerChangeTypes + ", propertyNamesHint=" + this.propertyNamesHint + ", valid=" + this.valid + ", external=" + this.external + ", listener=" + this.listener + "]";
    }
}

