/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceChangeListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"resource.paths=/", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
public class OsgiObservationBridge
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private final Logger logger = LoggerFactory.getLogger(OsgiObservationBridge.class);
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver resolver;
    private BlockingQueue<ResourceChange> changesQueue;
    private EventSendingJob job;

    protected void activate() throws LoginException {
        this.resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        this.changesQueue = new LinkedBlockingQueue<ResourceChange>();
        this.job = new EventSendingJob(this.changesQueue);
        Executors.newSingleThreadExecutor().submit(this.job);
    }

    @Reference(name="handlers", cardinality=ReferenceCardinality.AT_LEAST_ONE, service=EventHandler.class, target="(event.topics=org/apache/sling/api/resource/*)")
    private void bindEventHandler(EventHandler handler) {
        this.logger.warn("Found OSGi Event Handler for deprecated resource bridge: {}", (Object)handler);
    }

    protected void deactivate() {
        this.changesQueue.clear();
        this.job.stop();
        this.resolver.close();
    }

    public void onChange(List<ResourceChange> changes) {
        this.changesQueue.addAll(changes);
    }

    private void sendOsgiEvent(ResourceChange change) {
        String topic;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        switch (change.getType()) {
            case ADDED: {
                topic = "org/apache/sling/api/resource/Resource/ADDED";
                break;
            }
            case CHANGED: {
                topic = "org/apache/sling/api/resource/Resource/CHANGED";
                break;
            }
            case REMOVED: {
                topic = "org/apache/sling/api/resource/Resource/REMOVED";
                break;
            }
            default: {
                return;
            }
        }
        ((Dictionary)props).put("path", change.getPath());
        if (change.getUserId() != null) {
            ((Dictionary)props).put("userid", change.getUserId());
        }
        if (change.getAddedPropertyNames() != null) {
            ((Dictionary)props).put("resourceAddedAttributes", change.getAddedPropertyNames().toArray(new String[change.getAddedPropertyNames().size()]));
        }
        if (change.getChangedPropertyNames() != null) {
            ((Dictionary)props).put("resourceChangedAttributes", change.getChangedPropertyNames().toArray(new String[change.getChangedPropertyNames().size()]));
        }
        if (change.getRemovedPropertyNames() != null) {
            ((Dictionary)props).put("resourceRemovedAttributes", change.getRemovedPropertyNames().toArray(new String[change.getRemovedPropertyNames().size()]));
        }
        if (change.getType() != ResourceChange.ChangeType.REMOVED) {
            Resource resource = this.resolver.getResource(change.getPath());
            if (resource == null) {
                this.resolver.refresh();
                resource = this.resolver.getResource(change.getPath());
            }
            if (resource != null) {
                if (resource.getResourceType() != null) {
                    ((Dictionary)props).put("resourceType", resource.getResourceType());
                }
                if (resource.getResourceSuperType() != null) {
                    ((Dictionary)props).put("resourceSuperType", resource.getResourceSuperType());
                }
            }
        }
        if (change.isExternal()) {
            ((Dictionary)props).put("event.application", "unknown");
        }
        Event event = new Event(topic, props);
        this.eventAdmin.sendEvent(event);
    }

    private class EventSendingJob
    implements Runnable {
        private final BlockingQueue<ResourceChange> changes;
        private volatile boolean stop;

        public EventSendingJob(BlockingQueue<ResourceChange> changes) {
            this.changes = changes;
        }

        @Override
        public void run() {
            while (!this.stop) {
                ResourceChange change = null;
                try {
                    change = this.changes.poll(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    OsgiObservationBridge.this.logger.warn("Interrupted the OSGi runnable", (Throwable)e);
                }
                if (change == null) continue;
                try {
                    OsgiObservationBridge.this.sendOsgiEvent(change);
                }
                catch (Exception e) {
                    OsgiObservationBridge.this.logger.error("processOsgiEventQueue: Unexpected problem processing resource change {}", (Object)change, (Object)e);
                }
            }
        }

        public void stop() {
            this.stop = true;
        }
    }
}

