/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerInfo;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;

public class BasicObserverConfiguration
implements ObserverConfiguration {
    private final boolean includeExternal;
    private final PathSet paths;
    private final PathSet excludedPaths;
    private final Set<String> propertyNamesHint;
    private final Set<ResourceChange.ChangeType> changeTypes;
    private final List<ResourceChangeListenerInfo> listeners = new ArrayList<ResourceChangeListenerInfo>();

    public BasicObserverConfiguration(PathSet paths, Set<ResourceChange.ChangeType> types, boolean isExternal, PathSet excludePaths, Set<String> propertyNamesHint) {
        this.includeExternal = isExternal;
        this.paths = paths;
        this.changeTypes = Collections.unmodifiableSet(types);
        this.excludedPaths = excludePaths;
        this.propertyNamesHint = propertyNamesHint;
    }

    public BasicObserverConfiguration(PathSet set) {
        this.includeExternal = false;
        this.paths = set;
        HashSet<ResourceChange.ChangeType> types = new HashSet<ResourceChange.ChangeType>();
        types.add(ResourceChange.ChangeType.PROVIDER_ADDED);
        types.add(ResourceChange.ChangeType.PROVIDER_REMOVED);
        this.changeTypes = Collections.unmodifiableSet(types);
        this.excludedPaths = PathSet.EMPTY_SET;
        this.propertyNamesHint = null;
    }

    public void addListener(ResourceChangeListenerInfo listener) {
        this.listeners.add(listener);
        Collections.sort(this.listeners);
    }

    public List<ResourceChangeListenerInfo> getListeners() {
        return this.listeners;
    }

    public boolean includeExternal() {
        return this.includeExternal;
    }

    public PathSet getPaths() {
        return this.paths;
    }

    public PathSet getExcludedPaths() {
        return this.excludedPaths;
    }

    public Set<ResourceChange.ChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean matches(String path) {
        return this.paths.matches(path) != null && this.excludedPaths.matches(path) == null;
    }

    public Set<String> getPropertyNamesHint() {
        return this.propertyNamesHint;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changeTypes == null ? 0 : this.changeTypes.hashCode());
        result = 31 * result + (this.excludedPaths == null ? 0 : this.excludedPaths.hashCode());
        result = 31 * result + (this.includeExternal ? 1231 : 1237);
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        result = 31 * result + (this.propertyNamesHint == null ? 0 : this.propertyNamesHint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicObserverConfiguration other = (BasicObserverConfiguration)obj;
        if (this.changeTypes == null ? other.changeTypes != null : !this.changeTypes.equals(other.changeTypes)) {
            return false;
        }
        if (this.excludedPaths == null ? other.excludedPaths != null : !this.excludedPaths.equals((Object)other.excludedPaths)) {
            return false;
        }
        if (this.includeExternal != other.includeExternal) {
            return false;
        }
        if (this.paths == null ? other.paths != null : !this.paths.equals((Object)other.paths)) {
            return false;
        }
        return !(this.propertyNamesHint == null ? other.propertyNamesHint != null : !this.propertyNamesHint.equals(other.propertyNamesHint));
    }

    public String toString() {
        return "BasicObserverConfiguration [includeExternal=" + this.includeExternal + ", paths=" + this.paths + ", excludedPaths=" + this.excludedPaths + ", propertyNamesHint=" + this.propertyNamesHint + ", changeTypes=" + this.changeTypes + ", listeners=" + this.listeners + "]";
    }
}

