/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.stateful;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.helper.AbstractIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.stateful.AuthenticatedResourceProvider;
import org.apache.sling.resourceresolver.impl.providers.stateful.BasicResolveContext;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderManager {
    private static final Logger logger = LoggerFactory.getLogger(ProviderManager.class);
    private final ResourceResolver resolver;
    private final Map<ResourceProviderHandler, AuthenticatedResourceProvider> contextMap;
    private final List<AuthenticatedResourceProvider> authenticated = new ArrayList<AuthenticatedResourceProvider>();
    private final List<AuthenticatedResourceProvider> modifiable = new ArrayList<AuthenticatedResourceProvider>();
    private final List<AuthenticatedResourceProvider> refreshable = new ArrayList<AuthenticatedResourceProvider>();
    private final ResourceAccessSecurityTracker tracker;

    public ProviderManager(@Nonnull ResourceResolver resolver, @Nonnull ResourceAccessSecurityTracker tracker) {
        this.contextMap = new IdentityHashMap<ResourceProviderHandler, AuthenticatedResourceProvider>();
        this.resolver = resolver;
        this.tracker = tracker;
    }

    @CheckForNull
    public AuthenticatedResourceProvider getOrCreateProvider(@Nonnull ResourceProviderHandler handler, @Nonnull ResourceResolverControl control) throws LoginException {
        AuthenticatedResourceProvider provider = this.contextMap.get(handler);
        if (provider == null) {
            try {
                provider = this.authenticate(handler, control);
                this.contextMap.put(handler, provider);
                if (handler.getInfo().getAuthType() == AuthType.lazy || handler.getInfo().getAuthType() == AuthType.required) {
                    control.registerAuthenticatedProvider(handler, provider.getResolveContext().getProviderState());
                }
            }
            catch (LoginException le) {
                logger.debug("Authentication to resource provider " + handler.getResourceProvider() + " failed: " + le.getMessage(), (Throwable)le);
                this.contextMap.put(handler, AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER);
                throw le;
            }
        }
        return provider == AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER ? null : provider;
    }

    @CheckForNull
    public ResolveContext<Object> getOrCreateResolveContext(@Nonnull ResourceProviderHandler handler, @Nonnull ResourceResolverControl control) throws LoginException {
        AuthenticatedResourceProvider provider = this.getOrCreateProvider(handler, control);
        return provider == null ? null : provider.getResolveContext();
    }

    public void authenticateAll(@Nonnull List<ResourceProviderHandler> handlers, @Nonnull ResourceResolverControl control) throws LoginException {
        for (ResourceProviderHandler h : handlers) {
            try {
                this.getOrCreateProvider(h, control);
            }
            catch (LoginException le) {
                for (Map.Entry<ResourceProviderHandler, AuthenticatedResourceProvider> entry : this.contextMap.entrySet()) {
                    if (entry.getValue() == AuthenticatedResourceProvider.UNAUTHENTICATED_PROVIDER) continue;
                    entry.getKey().getResourceProvider().logout(entry.getValue().getResolveContext().getProviderState());
                }
                this.contextMap.clear();
                control.clearAuthenticatedProviders();
                throw le;
            }
        }
    }

    @Nonnull
    private AuthenticatedResourceProvider authenticate(@Nonnull ResourceProviderHandler handler, @Nonnull ResourceResolverControl control) throws LoginException {
        ResourceProvider<Object> provider = handler.getResourceProvider();
        boolean isAuthenticated = false;
        Object contextData = null;
        if (handler.getInfo().getAuthType() == AuthType.required || handler.getInfo().getAuthType() == AuthType.lazy) {
            try {
                contextData = provider.authenticate(control.getAuthenticationInfo());
                isAuthenticated = true;
            }
            catch (LoginException le) {
                logger.debug("Unable to login into resource provider " + provider, (Throwable)le);
                throw le;
            }
        }
        BasicResolveContext<Object> context = new BasicResolveContext<Object>(this.resolver, this, control, contextData, ResourceUtil.getParent((String)handler.getInfo().getPath()));
        AuthenticatedResourceProvider rp = new AuthenticatedResourceProvider(provider, handler.getInfo().getUseResourceAccessSecurity(), context, this.tracker);
        if (isAuthenticated) {
            this.authenticated.add(rp);
        }
        if (handler.getInfo().isModifiable()) {
            this.modifiable.add(rp);
        }
        if (handler.getInfo().isRefreshable()) {
            this.refreshable.add(rp);
        }
        return rp;
    }

    public Collection<AuthenticatedResourceProvider> getAllAuthenticated() {
        return this.authenticated;
    }

    public Collection<AuthenticatedResourceProvider> getAllUsedModifiable() {
        return this.modifiable;
    }

    public Collection<AuthenticatedResourceProvider> getAllUsedRefreshable() {
        return this.refreshable;
    }

    public Iterable<AuthenticatedResourceProvider> getAllBestEffort(@Nonnull List<ResourceProviderHandler> handlers, final @Nonnull ResourceResolverControl control) {
        final Iterator<ResourceProviderHandler> handlerIter = handlers.iterator();
        return new Iterable<AuthenticatedResourceProvider>(){

            @Override
            public Iterator<AuthenticatedResourceProvider> iterator() {
                return new AbstractIterator<AuthenticatedResourceProvider>(){

                    @Override
                    protected AuthenticatedResourceProvider seek() {
                        AuthenticatedResourceProvider result = null;
                        while (result == null && handlerIter.hasNext()) {
                            ResourceProviderHandler h = (ResourceProviderHandler)handlerIter.next();
                            try {
                                result = ProviderManager.this.getOrCreateProvider(h, control);
                            }
                            catch (LoginException loginException) {}
                        }
                        return result;
                    }
                };
            }
        };
    }
}

