/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.stateful;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.stateful.ProviderManager;
import org.apache.sling.resourceresolver.impl.providers.tree.Node;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class BasicResolveContext<T>
implements ResolveContext<T> {
    private final ResourceResolver resolver;
    private final ProviderManager resolveContextManager;
    private final ResourceResolverControl control;
    private final T providerState;
    private final String parentPath;
    private volatile boolean parentLookupDone = false;
    private volatile ResourceProvider<Object> parentProvider;
    private volatile ResolveContext<Object> parentResolveContext;

    public BasicResolveContext(@Nonnull ResourceResolver resolver, @Nonnull ProviderManager resolveContextManager, @Nonnull ResourceResolverControl control, @CheckForNull T providerState, @Nonnull String parentPath) {
        this.resolver = resolver;
        this.resolveContextManager = resolveContextManager;
        this.parentPath = parentPath;
        this.providerState = providerState;
        this.control = control;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public T getProviderState() {
        return this.providerState;
    }

    public ResolveContext<?> getParentResolveContext() {
        this.getParentResourceProvider();
        return this.parentResolveContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceProvider<?> getParentResourceProvider() {
        if (!this.parentLookupDone) {
            BasicResolveContext basicResolveContext = this;
            synchronized (basicResolveContext) {
                if (this.parentPath != null) {
                    String path = this.parentPath;
                    while (path != null && this.parentProvider != null) {
                        Node<ResourceProviderHandler> node = this.control.getResourceProviderStorage().getTree().getBestMatchingNode(this.parentPath);
                        if (node != null) {
                            ResourceProviderHandler handler = node.getValue();
                            try {
                                this.parentResolveContext = this.resolveContextManager.getOrCreateResolveContext(handler, this.control);
                                if (this.parentResolveContext != null) {
                                    this.parentProvider = handler.getResourceProvider();
                                }
                            }
                            catch (LoginException se) {
                                // empty catch block
                            }
                            if (this.parentProvider != null) continue;
                            path = ResourceUtil.getParent((String)path);
                            continue;
                        }
                        path = null;
                    }
                }
                this.parentLookupDone = true;
            }
        }
        return this.parentProvider;
    }
}

