/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.tree.PathTree;

public class ResourceProviderStorage {
    private final List<ResourceProviderHandler> allHandlers;
    private final List<ResourceProviderHandler> authRequiredHandlers;
    private final List<ResourceProviderHandler> adaptableHandlers;
    private final List<ResourceProviderHandler> attributableHandlers;
    private final List<ResourceProviderHandler> languageQueryableHandlers;
    private final PathTree<ResourceProviderHandler> handlersTree;

    public ResourceProviderStorage(List<ResourceProviderHandler> handlers) {
        this.allHandlers = handlers;
        this.authRequiredHandlers = new ArrayList<ResourceProviderHandler>();
        this.adaptableHandlers = new ArrayList<ResourceProviderHandler>();
        this.attributableHandlers = new ArrayList<ResourceProviderHandler>();
        this.languageQueryableHandlers = new ArrayList<ResourceProviderHandler>();
        for (ResourceProviderHandler h : this.allHandlers) {
            ResourceProviderInfo info = h.getInfo();
            if (info.getAuthType() == AuthType.required) {
                this.authRequiredHandlers.add(h);
            }
            if (info.isAdaptable()) {
                this.adaptableHandlers.add(h);
            }
            if (info.isAttributable()) {
                this.attributableHandlers.add(h);
            }
            if (h.getResourceProvider().getQueryLanguageProvider() == null) continue;
            this.languageQueryableHandlers.add(h);
        }
        this.handlersTree = new PathTree<ResourceProviderHandler>(handlers);
    }

    public List<ResourceProviderHandler> getAllHandlers() {
        return this.allHandlers;
    }

    public List<ResourceProviderHandler> getAuthRequiredHandlers() {
        return this.authRequiredHandlers;
    }

    public List<ResourceProviderHandler> getAdaptableHandlers() {
        return this.adaptableHandlers;
    }

    public List<ResourceProviderHandler> getAttributableHandlers() {
        return this.attributableHandlers;
    }

    public List<ResourceProviderHandler> getLanguageQueryableHandlers() {
        return this.languageQueryableHandlers;
    }

    public PathTree<ResourceProviderHandler> getTree() {
        return this.handlersTree;
    }
}

