/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import org.apache.sling.resourceresolver.impl.providers.ProviderContextImpl;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.tree.Pathable;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;

public class ResourceProviderHandler
implements Comparable<ResourceProviderHandler>,
Pathable {
    private final ResourceProviderInfo info;
    private final BundleContext bundleContext;
    private final ProviderContextImpl context = new ProviderContextImpl();
    private volatile ResourceProvider<Object> provider;

    public ResourceProviderHandler(BundleContext bc, ResourceProviderInfo info) {
        this.info = info;
        this.bundleContext = bc;
    }

    public ResourceProviderInfo getInfo() {
        return this.info;
    }

    public boolean activate() {
        this.provider = (ResourceProvider)this.bundleContext.getService(this.info.getServiceReference());
        if (this.provider != null) {
            this.provider.start((ProviderContext)this.context);
        }
        return this.provider != null;
    }

    public ResourceProvider<Object> getResourceProvider() {
        return this.provider;
    }

    public void deactivate() {
        if (this.provider != null) {
            this.provider.stop();
            this.provider = null;
            this.context.update(null, null);
            this.bundleContext.ungetService(this.info.getServiceReference());
        }
    }

    @Override
    public int compareTo(ResourceProviderHandler o) {
        return this.getInfo().compareTo(o.getInfo());
    }

    @Override
    public String getPath() {
        return this.getInfo().getPath();
    }

    public void update() {
        if (this.provider != null) {
            this.provider.update(3L);
        }
    }

    public ProviderContextImpl getProviderContext() {
        return this.context;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "# provider: " + this.provider + " ]";
    }
}

