/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.api.resource.DynamicResourceProvider;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.RefreshableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;

public class ResourceResolverContext {
    private final Map<Long, ResourceProvider> providers = new HashMap<Long, ResourceProvider>();
    private final Set<DynamicResourceProvider> dynamicProviders = new HashSet<DynamicResourceProvider>();
    private final Set<RefreshableResourceProvider> refreshableProviders = new HashSet<RefreshableResourceProvider>();
    private final Set<ModifyingResourceProvider> modifyingProviders = new HashSet<ModifyingResourceProvider>();
    private final boolean isAdmin;
    private final Map<String, Object> originalAuthInfo;
    private final ResourceAccessSecurityTracker resourceAccessSecurityTracker;
    private ResourceResolver resourceTypeResourceResolver;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public ResourceResolverContext(boolean isAdmin, Map<String, Object> originalAuthInfo, ResourceAccessSecurityTracker resourceAccessSecurityTracker) {
        this.isAdmin = isAdmin;
        this.originalAuthInfo = originalAuthInfo;
        this.resourceAccessSecurityTracker = resourceAccessSecurityTracker;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public Map<String, Object> getAuthenticationInfo() {
        return this.originalAuthInfo;
    }

    public void addFactoryResourceProvider(Long key, ResourceProvider provider) {
        this.providers.put(key, provider);
        if (provider instanceof DynamicResourceProvider) {
            this.dynamicProviders.add((DynamicResourceProvider)provider);
        }
        if (provider instanceof ModifyingResourceProvider) {
            this.modifyingProviders.add((ModifyingResourceProvider)provider);
        }
        if (provider instanceof RefreshableResourceProvider) {
            this.refreshableProviders.add((RefreshableResourceProvider)provider);
        }
    }

    public ResourceProvider getFactoryResourceProvider(Long key) {
        return this.providers.get(key);
    }

    public boolean isLive() {
        boolean result = true;
        for (DynamicResourceProvider provider : this.dynamicProviders) {
            if (provider.isLive()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            for (DynamicResourceProvider provider : this.dynamicProviders) {
                provider.close();
            }
            this.dynamicProviders.clear();
            this.providers.clear();
            this.refreshableProviders.clear();
            if (this.resourceTypeResourceResolver != null) {
                this.resourceTypeResourceResolver.close();
                this.resourceTypeResourceResolver = null;
            }
        }
    }

    public void revert(ResourceResolver resolver) {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            provider.revert(resolver);
        }
    }

    public void commit(ResourceResolver resolver) throws PersistenceException {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            provider.commit(resolver);
        }
    }

    public boolean hasChanges(ResourceResolver resolver) {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            if (!provider.hasChanges(resolver)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        for (RefreshableResourceProvider provider : this.refreshableProviders) {
            provider.refresh();
        }
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.resourceAccessSecurityTracker;
    }

    private ResourceResolver getResourceTypeResourceResolver(ResourceResolverFactory factory, ResourceResolver resolver) {
        if (this.isAdmin) {
            return resolver;
        }
        if (this.resourceTypeResourceResolver == null) {
            try {
                this.resourceTypeResourceResolver = factory.getAdministrativeResourceResolver(null);
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        return this.resourceTypeResourceResolver;
    }

    public String getParentResourceType(ResourceResolverFactory factory, ResourceResolver resolver, String resourceType) {
        Resource rtResource;
        ResourceResolver adminResolver;
        String rtPath = resourceType == null ? null : ResourceUtil.resourceTypeToPath((String)resourceType);
        String resourceSuperType = null;
        if (rtPath != null && (adminResolver = this.getResourceTypeResourceResolver(factory, resolver)) != null && (rtResource = adminResolver.getResource(rtPath)) != null) {
            resourceSuperType = rtResource.getResourceSuperType();
        }
        return resourceSuperType;
    }

    public static String getProperty(Resource res, String propName) {
        return ResourceResolverContext.getProperty(res, propName, String.class);
    }

    public static <Type> Type getProperty(Resource res, String propName, Class<Type> type) {
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        if (props != null) {
            Object prop = props.get(propName, type);
            if (prop != null) {
                return (Type)prop;
            }
            prop = props.get("jcr:content/" + propName, type);
            return (Type)prop;
        }
        return null;
    }
}

