/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProviderFactoryHandler
extends ProviderHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ResourceProvider NULL_PROVIDER = new ResourceProvider(){

        public Iterator<Resource> listChildren(Resource parent) {
            return null;
        }

        public Resource getResource(ResourceResolver resourceResolver, String path) {
            return null;
        }

        public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
            return null;
        }
    };
    private final ResourceProviderFactory resourceProviderFactory;

    public ResourceProviderFactoryHandler(ResourceProviderFactory factory, Map<String, Object> properties) {
        super(properties);
        this.resourceProviderFactory = factory;
    }

    @Override
    public ResourceProvider getResourceProvider(ResourceResolverContext ctx) {
        ResourceProvider rp = ctx.getFactoryResourceProvider(this.getServiceId());
        if (rp == null) {
            try {
                rp = this.login(ctx);
            }
            catch (LoginException le) {
                this.logger.debug("Unable to login to " + this.getName(), (Throwable)le);
            }
            if (rp == null) {
                ctx.addFactoryResourceProvider(this.getServiceId(), NULL_PROVIDER);
            }
        } else if (rp == NULL_PROVIDER) {
            rp = null;
        }
        return rp;
    }

    @Override
    public Resource getResource(ResourceResolverContext ctx, ResourceResolver resourceResolver, String path) {
        ResourceProvider rp = this.getResourceProvider(ctx);
        if (rp != null) {
            return rp.getResource(resourceResolver, path);
        }
        return null;
    }

    @Override
    public Iterator<Resource> listChildren(ResourceResolverContext ctx, Resource parent) {
        ResourceProvider rp = this.getResourceProvider(ctx);
        if (rp != null) {
            return rp.listChildren(parent);
        }
        return null;
    }

    public int hashCode() {
        return this.resourceProviderFactory.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceProviderFactoryHandler) {
            return this.resourceProviderFactory.equals(((ResourceProviderFactoryHandler)obj).resourceProviderFactory);
        }
        if (obj instanceof ResourceProviderFactory) {
            return this.resourceProviderFactory.equals(obj);
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.resourceProviderFactory.toString();
    }

    public ResourceProvider login(ResourceResolverContext ctx) throws LoginException {
        ResourceProvider rp = ctx.isAdmin() ? this.resourceProviderFactory.getAdministrativeResourceProvider(ctx.getAuthenticationInfo()) : this.resourceProviderFactory.getResourceProvider(ctx.getAuthenticationInfo());
        ctx.addFactoryResourceProvider(this.getServiceId(), rp);
        return rp;
    }
}

