/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.FastTreeMap;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.tree.ProviderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProviderEntry
implements Comparable<ResourceProviderEntry> {
    private final Logger logger = LoggerFactory.getLogger(ResourceProviderEntry.class);
    private final String path;
    private final String prefix;
    private ProviderHandler[] providers = new ProviderHandler[0];
    private final FastTreeMap storageMap = new FastTreeMap();
    private Collection<ResourceProviderEntry> storageMapValues = new ArrayList<ResourceProviderEntry>();
    private static final char SPLIT_SEP = '/';
    private static final String[] EMPTY_RESULT = new String[0];

    public ResourceProviderEntry(String path, ProviderHandler[] providerList) {
        if (path.endsWith("/")) {
            this.path = path.substring(0, path.length() - 1);
            this.prefix = path;
        } else {
            this.path = path;
            this.prefix = path + "/";
        }
        if (providerList != null) {
            this.providers = new ProviderHandler[providerList.length];
            for (int i = 0; i < providerList.length; ++i) {
                this.providers[i] = providerList[i];
            }
        }
        this.storageMap.setFast(true);
    }

    public String getPath() {
        return this.path;
    }

    public ProviderHandler[] getResourceProviders() {
        return this.providers;
    }

    public Resource getResource(ResourceResolverContext ctx, ResourceResolver resourceResolver, String path) {
        return this.getInternalResource(ctx, resourceResolver, path);
    }

    public void put(String key, ResourceProviderEntry value) {
        this.storageMap.put((Object)key, (Object)value);
        this.storageMapValues = new ArrayList<ResourceProviderEntry>(this.storageMap.values());
    }

    public boolean containsKey(String key) {
        return this.storageMap.containsKey((Object)key);
    }

    public ResourceProviderEntry get(String key) {
        return (ResourceProviderEntry)this.storageMap.get((Object)key);
    }

    public Collection<ResourceProviderEntry> values() {
        return this.storageMapValues;
    }

    @Override
    public int compareTo(ResourceProviderEntry o) {
        return this.prefix.compareTo(o.prefix);
    }

    private boolean addInternalProvider(ProviderHandler provider) {
        int before = this.providers.length;
        HashSet<ProviderHandler> set = new HashSet<ProviderHandler>();
        set.addAll(Arrays.asList(this.providers));
        this.logger.debug("Adding provider {} at {} ", (Object)provider, (Object)this.path);
        set.add(provider);
        this.providers = this.conditionalSort(set);
        return this.providers.length > before;
    }

    private boolean removeInternalProvider(ProviderHandler provider) {
        int before = this.providers.length;
        HashSet<ProviderHandler> set = new HashSet<ProviderHandler>();
        set.addAll(Arrays.asList(this.providers));
        this.logger.debug("Removing provider {} at {} ", (Object)provider, (Object)this.path);
        set.remove(provider);
        this.providers = this.conditionalSort(set);
        return this.providers.length < before;
    }

    protected synchronized boolean addResourceProvider(String prefix, ProviderHandler provider) {
        String[] elements = ResourceProviderEntry.split(prefix);
        ArrayList<ResourceProviderEntry> entries = new ArrayList<ResourceProviderEntry>();
        this.populateProviderPath(entries, elements);
        entries.add(0, this);
        for (int i = entries.size() - 1; i < elements.length; ++i) {
            String stubPrefix = elements[i];
            ResourceProviderEntry rpe2 = new ResourceProviderEntry(stubPrefix, new ProviderHandler[0]);
            ((ResourceProviderEntry)entries.get(i)).put(stubPrefix, rpe2);
            entries.add(rpe2);
        }
        return ((ResourceProviderEntry)entries.get(elements.length)).addInternalProvider(provider);
    }

    protected synchronized boolean removeResourceProvider(String prefix, ProviderHandler resourceProvider) {
        boolean result = false;
        String[] elements = ResourceProviderEntry.split(prefix);
        ArrayList<ResourceProviderEntry> entries = new ArrayList<ResourceProviderEntry>();
        this.populateProviderPath(entries, elements);
        if (entries.size() == 0) {
            result = this.removeInternalProvider(resourceProvider);
        } else if (entries.size() > 0 && entries.size() == elements.length) {
            result = ((ResourceProviderEntry)entries.get(entries.size() - 1)).removeInternalProvider(resourceProvider);
        }
        if (!result) {
            this.logger.warn("Unable to remove {} for prefix {}, no matching entry found", (Object)resourceProvider, (Object)prefix);
        }
        return result;
    }

    private ProviderHandler[] conditionalSort(Set<ProviderHandler> set) {
        ArrayList<ProviderHandler> providerList = new ArrayList<ProviderHandler>(set);
        Collections.sort(providerList);
        return providerList.toArray(new ProviderHandler[providerList.size()]);
    }

    private void populateProviderPath(List<ResourceProviderEntry> entries, String[] elements) {
        ResourceProviderEntry base = this;
        for (String element : elements) {
            if (element == null) continue;
            if (!base.containsKey(element)) break;
            base = base.get(element);
            entries.add(base);
        }
    }

    private Resource getInternalResource(ResourceResolverContext ctx, ResourceResolver resourceResolver, String fullPath) {
        try {
            if (fullPath == null || fullPath.length() == 0 || fullPath.charAt(0) != '/') {
                this.logger.debug("Not absolute {}", (Object)fullPath);
                return null;
            }
            String[] elements = ResourceProviderEntry.split(fullPath);
            ArrayList<ResourceProviderEntry> entries = new ArrayList<ResourceProviderEntry>();
            this.populateProviderPath(entries, elements);
            Resource fallbackResource = null;
            for (int i = entries.size() - 1; i >= 0; --i) {
                Object[] rps;
                for (ProviderHandler providerHandler : rps = ((ResourceProviderEntry)entries.get(i)).getResourceProviders()) {
                    boolean foundFallback = false;
                    Resource resource = providerHandler.getResource(ctx, resourceResolver, fullPath);
                    if (resource != null) {
                        if (resource.getResourceMetadata() != null && resource.getResourceMetadata().get((Object)":org.apache.sling.resource.internal.continue.resolving") != null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Resolved Full {} using {} from {} - continue resolving flag is set!", new Object[]{fullPath, providerHandler, Arrays.toString(rps)});
                            }
                            fallbackResource = resource;
                            fallbackResource.getResourceMetadata().remove((Object)":org.apache.sling.resource.internal.continue.resolving");
                            foundFallback = true;
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Resolved Full {} using {} from {} ", new Object[]{fullPath, providerHandler, Arrays.toString(rps)});
                            }
                            return resource;
                        }
                    }
                    if (!providerHandler.ownsRoots() || foundFallback) continue;
                    this.logger.debug("Resource null {} ", (Object)fullPath);
                    return fallbackResource;
                }
            }
            Resource resource = this.getResourceFromProviders(ctx, resourceResolver, fullPath);
            if (resource != null) {
                return resource;
            }
            if (fallbackResource != null) {
                this.logger.debug("Using first found resource {} for {}", fallbackResource, (Object)fullPath);
                return fallbackResource;
            }
            if (entries.size() > 0 && entries.size() == elements.length && ((ResourceProviderEntry)entries.get(entries.size() - 1)).getResourceProviders().length == 0) {
                this.logger.debug("Resolved Synthetic {}", (Object)fullPath);
                return new SyntheticResource(resourceResolver, fullPath, "sling:syntheticResourceProviderResource");
            }
            this.logger.debug("Resource null {} ", (Object)fullPath);
            return null;
        }
        catch (Exception ex) {
            this.logger.debug("Failed! ", (Throwable)ex);
            return null;
        }
    }

    public Resource getResourceFromProviders(ResourceResolverContext ctx, ResourceResolver resourceResolver, String fullPath) {
        ProviderHandler[] rps;
        Resource fallbackResource = null;
        for (ProviderHandler rp : rps = this.getResourceProviders()) {
            boolean foundFallback = false;
            Resource resource = rp.getResource(ctx, resourceResolver, fullPath);
            if (resource != null) {
                if (resource.getResourceMetadata() != null && resource.getResourceMetadata().get((Object)":org.apache.sling.resource.internal.continue.resolving") != null) {
                    this.logger.debug("Resolved Base {} using {} - continue resolving flag is set!", (Object)fullPath, (Object)rp);
                    fallbackResource = resource;
                    fallbackResource.getResourceMetadata().remove((Object)":org.apache.sling.resource.internal.continue.resolving");
                    foundFallback = true;
                } else {
                    this.logger.debug("Resolved Base {} using {} ", (Object)fullPath, (Object)rp);
                    return resource;
                }
            }
            if (!rp.ownsRoots() || foundFallback) continue;
            this.logger.debug("Resource null {} ", (Object)fullPath);
            return fallbackResource;
        }
        return fallbackResource;
    }

    public ModifyingResourceProvider getModifyingProvider(ResourceResolverContext ctx, ResourceResolver resourceResolver, String fullPath) {
        String[] elements = ResourceProviderEntry.split(fullPath);
        ArrayList<ResourceProviderEntry> entries = new ArrayList<ResourceProviderEntry>();
        this.populateProviderPath(entries, elements);
        for (int i = entries.size() - 1; i >= 0; --i) {
            ProviderHandler[] rps;
            for (ProviderHandler rp : rps = ((ResourceProviderEntry)entries.get(i)).getResourceProviders()) {
                ResourceProvider provider = rp.getResourceProvider(ctx);
                if (provider instanceof ModifyingResourceProvider) {
                    return (ModifyingResourceProvider)provider;
                }
                if (!rp.ownsRoots()) continue;
                return null;
            }
        }
        for (ProviderHandler rp : this.providers) {
            ResourceProvider provider = rp.getResourceProvider(ctx);
            if (!(provider instanceof ModifyingResourceProvider)) continue;
            return (ModifyingResourceProvider)provider;
        }
        return null;
    }

    public static String[] split(String st) {
        int start;
        if (st == null) {
            return EMPTY_RESULT;
        }
        char[] pn = st.toCharArray();
        if (pn.length == 0) {
            return EMPTY_RESULT;
        }
        if (pn.length == 1 && pn[0] == '/') {
            return EMPTY_RESULT;
        }
        int n = 1;
        int end = pn.length;
        for (start = 0; start < end && '/' == pn[start]; ++start) {
        }
        while (start < end && '/' == pn[end - 1]) {
            --end;
        }
        for (int i = start; i < end; ++i) {
            if ('/' != pn[i]) continue;
            ++n;
        }
        String[] e = new String[n];
        int s = start;
        int j = 0;
        for (int i = start; i < end; ++i) {
            if (pn[i] != '/') continue;
            e[j++] = new String(pn, s, i - s);
            s = i + 1;
        }
        if (s < end) {
            e[j++] = new String(pn, s, end - s);
        }
        return e;
    }

    public String toString() {
        return this.path;
    }
}

