/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderHandler
implements Comparable<ProviderHandler> {
    private final Map<String, Object> properties;
    private final Long serviceId;
    private final String[] roots;
    private final Set<String> queryLanguages;
    private final boolean ownsRoots;

    public ProviderHandler(Map<String, Object> properties) {
        this.properties = properties;
        this.serviceId = (Long)properties.get("service.id");
        ArrayList<String> configuredRoots = new ArrayList<String>();
        String[] paths = PropertiesUtil.toStringArray((Object)properties.get("provider.roots"));
        if (paths != null) {
            for (String r : paths) {
                if (r == null) continue;
                String path = r.trim();
                if (path.endsWith("/") && path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.length() <= 0 || configuredRoots.contains(path)) continue;
                configuredRoots.add(path);
            }
        }
        if (configuredRoots.size() == 0) {
            this.roots = null;
        } else {
            Collections.sort(configuredRoots);
            this.roots = configuredRoots.toArray(new String[configuredRoots.size()]);
        }
        this.ownsRoots = PropertiesUtil.toBoolean((Object)properties.get("provider.ownsRoots"), (boolean)false);
        HashSet<String> configuredLanguages = new HashSet<String>();
        String[] languages = PropertiesUtil.toStringArray((Object)properties.get("provider.query.languages"));
        if (languages != null) {
            for (String l : languages) {
                String language;
                if (l == null || (language = l.trim()).length() <= 0) continue;
                configuredLanguages.add(language);
            }
        }
        this.queryLanguages = configuredLanguages.size() == 0 ? null : configuredLanguages;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public boolean ownsRoots() {
        return this.ownsRoots;
    }

    public String[] getRoots() {
        return this.roots;
    }

    public boolean supportsQueryLanguages(String language) {
        return this.queryLanguages != null && this.queryLanguages.contains(language);
    }

    @Override
    public int compareTo(ProviderHandler other) {
        Integer otherRank;
        if (this.serviceId.equals(other.serviceId)) {
            return 0;
        }
        Object rankObj = this.getProperties().get("service.ranking");
        Object otherRankObj = other.getProperties().get("service.ranking");
        rankObj = rankObj == null ? new Integer(0) : rankObj;
        otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
        Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
        Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
        if (rank.compareTo(otherRank) < 0) {
            return -1;
        }
        if (rank.compareTo(otherRank) > 0) {
            return 1;
        }
        return this.serviceId.compareTo(other.serviceId) < 0 ? 1 : -1;
    }

    public abstract Resource getResource(ResourceResolverContext var1, ResourceResolver var2, String var3);

    public abstract Iterator<Resource> listChildren(ResourceResolverContext var1, Resource var2);

    public abstract ResourceProvider getResourceProvider(ResourceResolverContext var1);

    public String getName() {
        StringBuilder snBuilder = new StringBuilder(64);
        snBuilder.append('{');
        snBuilder.append(this.toString());
        snBuilder.append('/');
        snBuilder.append(this.serviceId.toString());
        snBuilder.append('}');
        return snBuilder.toString();
    }
}

