/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.DynamicResourceProvider;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.RefreshableResourceProvider;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResolverContext {
    private final Map<Long, ResourceProvider> providers = new HashMap<Long, ResourceProvider>();
    private final Set<DynamicResourceProvider> dynamicProviders = new HashSet<DynamicResourceProvider>();
    private final Set<RefreshableResourceProvider> refreshableProviders = new HashSet<RefreshableResourceProvider>();
    private final Set<ModifyingResourceProvider> modifyingProviders = new HashSet<ModifyingResourceProvider>();
    private final boolean isAdmin;
    private final Map<String, Object> originalAuthInfo;

    public ResourceResolverContext(boolean isAdmin, Map<String, Object> originalAuthInfo) {
        this.isAdmin = isAdmin;
        this.originalAuthInfo = originalAuthInfo;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public Map<String, Object> getAuthenticationInfo() {
        return this.originalAuthInfo;
    }

    public void addFactoryResourceProvider(Long key, ResourceProvider provider) {
        this.providers.put(key, provider);
        if (provider instanceof DynamicResourceProvider) {
            this.dynamicProviders.add((DynamicResourceProvider)provider);
        }
        if (provider instanceof ModifyingResourceProvider) {
            this.modifyingProviders.add((ModifyingResourceProvider)provider);
        }
        if (provider instanceof RefreshableResourceProvider) {
            this.refreshableProviders.add((RefreshableResourceProvider)provider);
        }
    }

    public ResourceProvider getFactoryResourceProvider(Long key) {
        return this.providers.get(key);
    }

    public boolean isLive() {
        boolean result = true;
        for (DynamicResourceProvider provider : this.dynamicProviders) {
            if (provider.isLive()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void close() {
        for (DynamicResourceProvider provider : this.dynamicProviders) {
            provider.close();
        }
        this.dynamicProviders.clear();
        this.providers.clear();
        this.refreshableProviders.clear();
    }

    public void revert(ResourceResolver resolver) {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            provider.revert(resolver);
        }
    }

    public void commit(ResourceResolver resolver) throws PersistenceException {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            provider.commit(resolver);
        }
    }

    public boolean hasChanges(ResourceResolver resolver) {
        for (ModifyingResourceProvider provider : this.modifyingProviders) {
            if (!provider.hasChanges(resolver)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        for (RefreshableResourceProvider provider : this.refreshableProviders) {
            provider.refresh();
        }
    }
}

