/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.console.ResourceResolverWebConsolePlugin;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntries;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.tree.RootResourceProviderEntry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResolverFactoryImpl
implements ResourceResolverFactory,
MapConfigurationProvider {
    private MapEntries mapEntries = MapEntries.EMPTY;
    private ResourceResolverWebConsolePlugin plugin;
    private final ResourceResolverFactoryActivator activator;

    public ResourceResolverFactoryImpl(ResourceResolverFactoryActivator activator) {
        this.activator = activator;
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceResolverInternal(authenticationInfo, false);
    }

    private ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        ResourceResolverContext ctx = new ResourceResolverContext(isAdmin, authenticationInfo);
        this.activator.getRootProviderEntry().loginToRequiredFactories(ctx);
        return new ResourceResolverImpl(this, ctx);
    }

    public MapEntries getMapEntries() {
        return this.mapEntries;
    }

    protected void activate(BundleContext bundleContext) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            this.plugin = new ResourceResolverWebConsolePlugin(bundleContext, this);
        }
        catch (Throwable ignore) {
            logger.debug("activate: unable to setup web console plugin.", ignore);
        }
        try {
            this.mapEntries = new MapEntries(this, bundleContext, this.activator.getEventAdmin());
        }
        catch (Exception e) {
            logger.error("activate: Cannot access repository, failed setting up Mapping Support", (Throwable)e);
        }
    }

    protected void deactivate() {
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
        if (this.mapEntries != null) {
            this.mapEntries.dispose();
            this.mapEntries = MapEntries.EMPTY;
        }
    }

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.activator.getResourceDecoratorTracker();
    }

    public String[] getSearchPath() {
        return this.activator.getSearchPath();
    }

    public boolean isMangleNamespacePrefixes() {
        return this.activator.isMangleNamespacePrefixes();
    }

    @Override
    public String getMapRoot() {
        return this.activator.getMapRoot();
    }

    @Override
    public Mapping[] getMappings() {
        return this.activator.getMappings();
    }

    public BidiMap getVirtualURLMap() {
        return this.activator.getVirtualURLMap();
    }

    public RootResourceProviderEntry getRootProviderEntry() {
        return this.activator.getRootProviderEntry();
    }

    @Override
    public int getDefaultVanityPathRedirectStatus() {
        return this.activator.getDefaultVanityPathRedirectStatus();
    }
}

