/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.FactoryPreconditions;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.tree.RootResourceProviderEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl", label="%resource.resolver.name", description="%resource.resolver.description", specVersion="1.1", metatype=true)
@Properties(value={@Property(name="service.description", value={"Apache Sling Resource Resolver Factory"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
@References(value={@Reference(name="ResourceProvider", referenceInterface=ResourceProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="ResourceProviderFactory", referenceInterface=ResourceProviderFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="ResourceDecorator", referenceInterface=ResourceDecorator.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class ResourceResolverFactoryActivator {
    @Property(value={"/apps", "/libs"})
    public static final String PROP_PATH = "resource.resolver.searchpath";
    @Property(boolValue={true})
    private static final String PROP_MANGLE_NAMESPACES = "resource.resolver.manglenamespaces";
    @Property(boolValue={true})
    private static final String PROP_ALLOW_DIRECT = "resource.resolver.allowDirect";
    @Property(unbounded=PropertyUnbounded.ARRAY, value={"org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory"})
    private static final String PROP_REQUIRED_PROVIDERS = "resource.resolver.required.providers";
    @Property(value={"/:/"}, unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_VIRTUAL = "resource.resolver.virtual";
    @Property(value={"/:/", "/content/:/", "/system/docroot/:/"})
    private static final String PROP_MAPPING = "resource.resolver.mapping";
    @Property(value={"/etc/map"})
    private static final String PROP_MAP_LOCATION = "resource.resolver.map.location";
    @Property(intValue={302})
    private static final String PROP_DEFAULT_VANITY_PATH_REDIRECT_STATUS = "resource.resolver.default.vanity.redirect.status";
    private final ResourceDecoratorTracker resourceDecoratorTracker = new ResourceDecoratorTracker();
    private Mapping[] mappings;
    private BidiMap virtualURLMap;
    private boolean allowDirect = false;
    private String[] searchPath;
    private String mapRoot;
    private boolean mangleNamespacePrefixes;
    private final RootResourceProviderEntry rootProviderEntry = new RootResourceProviderEntry();
    @Reference
    EventAdmin eventAdmin;
    private volatile ComponentContext componentContext;
    private int defaultVanityPathRedirectStatus;
    private final FactoryPreconditions preconds = new FactoryPreconditions();
    private volatile FactoryRegistration factoryRegistration;

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.resourceDecoratorTracker;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public RootResourceProviderEntry getRootProviderEntry() {
        return this.rootProviderEntry;
    }

    public BidiMap getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public String[] getSearchPath() {
        return this.searchPath;
    }

    public boolean isMangleNamespacePrefixes() {
        return this.mangleNamespacePrefixes;
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    public int getDefaultVanityPathRedirectStatus() {
        return this.defaultVanityPathRedirectStatus;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.rootProviderEntry.setEventAdmin(this.eventAdmin);
        Dictionary properties = componentContext.getProperties();
        TreeBidiMap virtuals = new TreeBidiMap();
        String[] virtualList = PropertiesUtil.toStringArray(properties.get(PROP_VIRTUAL));
        for (int i = 0; virtualList != null && i < virtualList.length; ++i) {
            String[] parts = Mapping.split(virtualList[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        String[] mappingList = (String[])properties.get(PROP_MAPPING);
        for (int i = 0; mappingList != null && i < mappingList.length; ++i) {
            maps.add(new Mapping(mappingList[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        Boolean directProp = (Boolean)properties.get(PROP_ALLOW_DIRECT);
        boolean bl = this.allowDirect = directProp != null ? directProp : true;
        if (this.allowDirect) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        this.searchPath = PropertiesUtil.toStringArray(properties.get(PROP_PATH));
        if (this.searchPath != null && this.searchPath.length > 0) {
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!this.searchPath[i].startsWith("/")) {
                    this.searchPath[i] = "/" + this.searchPath[i];
                }
                if (this.searchPath[i].endsWith("/")) continue;
                int n = i;
                this.searchPath[n] = this.searchPath[n] + "/";
            }
        }
        if (this.searchPath == null) {
            this.searchPath = new String[]{"/"};
        }
        this.mangleNamespacePrefixes = PropertiesUtil.toBoolean(properties.get(PROP_MANGLE_NAMESPACES), (boolean)false);
        this.mapRoot = PropertiesUtil.toString(properties.get(PROP_MAP_LOCATION), (String)"/etc/map");
        this.defaultVanityPathRedirectStatus = PropertiesUtil.toInteger(properties.get(PROP_DEFAULT_VANITY_PATH_REDIRECT_STATUS), (int)302);
        BundleContext bc = componentContext.getBundleContext();
        String[] required = PropertiesUtil.toStringArray(properties.get(PROP_REQUIRED_PROVIDERS));
        this.preconds.activate(bc, required);
        this.checkFactoryPreconditions();
    }

    @Deactivate
    protected void deactivate() {
        this.componentContext = null;
        this.preconds.deactivate();
        this.rootProviderEntry.setEventAdmin(null);
        this.resourceDecoratorTracker.close();
        this.unregisterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFactory() {
        FactoryRegistration local = null;
        ResourceResolverFactoryActivator resourceResolverFactoryActivator = this;
        synchronized (resourceResolverFactoryActivator) {
            if (this.factoryRegistration != null) {
                local = this.factoryRegistration;
                this.factoryRegistration = null;
            }
        }
        this.unregisterFactory(local);
    }

    private void unregisterFactory(FactoryRegistration local) {
        if (local != null) {
            if (local.factoryRegistration != null) {
                local.factoryRegistration.unregister();
            }
            if (local.factory != null) {
                local.factory.deactivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFactory(ComponentContext localContext) {
        FactoryRegistration local = null;
        ResourceResolverFactoryActivator resourceResolverFactoryActivator = this;
        synchronized (resourceResolverFactoryActivator) {
            if (this.factoryRegistration == null) {
                local = this.factoryRegistration = new FactoryRegistration();
            }
        }
        if (local != null) {
            local.factory = new ResourceResolverFactoryImpl(this);
            local.factory.activate(localContext.getBundleContext());
            Hashtable serviceProps = new Hashtable();
            ((Dictionary)serviceProps).put("service.vendor", localContext.getProperties().get("service.vendor"));
            ((Dictionary)serviceProps).put("service.description", localContext.getProperties().get("service.description"));
            local.factoryRegistration = localContext.getBundleContext().registerService(ResourceResolverFactory.class.getName(), (Object)local.factory, serviceProps);
            boolean doUnregister = false;
            ResourceResolverFactoryActivator resourceResolverFactoryActivator2 = this;
            synchronized (resourceResolverFactoryActivator2) {
                if (this.factoryRegistration != local) {
                    doUnregister = true;
                }
            }
            if (doUnregister) {
                this.unregisterFactory(local);
            }
        }
    }

    private void checkFactoryPreconditions() {
        ComponentContext localContext = this.componentContext;
        if (localContext != null) {
            boolean result = this.preconds.checkPreconditions();
            if (result) {
                this.registerFactory(localContext);
            } else {
                this.unregisterFactory();
            }
        }
    }

    protected void bindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        this.rootProviderEntry.bindResourceProvider(provider, props);
        this.preconds.bindProvider(props);
        this.checkFactoryPreconditions();
    }

    protected void unbindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        this.rootProviderEntry.unbindResourceProvider(provider, props);
        this.preconds.unbindProvider(props);
        this.checkFactoryPreconditions();
    }

    protected void bindResourceProviderFactory(ResourceProviderFactory provider, Map<String, Object> props) {
        this.rootProviderEntry.bindResourceProviderFactory(provider, props);
        this.preconds.bindProvider(props);
        this.checkFactoryPreconditions();
    }

    protected void unbindResourceProviderFactory(ResourceProviderFactory provider, Map<String, Object> props) {
        this.rootProviderEntry.unbindResourceProviderFactory(provider, props);
        this.preconds.unbindProvider(props);
        this.checkFactoryPreconditions();
    }

    protected void bindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.bindResourceDecorator(decorator, props);
    }

    protected void unbindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.unbindResourceDecorator(decorator, props);
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    private static final class FactoryRegistration {
        public volatile ResourceResolverFactoryImpl factory;
        public volatile ServiceRegistration factoryRegistration;

        private FactoryRegistration() {
        }
    }
}

