/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovePipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(RemovePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/rm";
    Resource filter = this.getConfiguration();

    public RemovePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        Resource resource = this.getInput();
        String parentPath = null;
        if (resource.adaptTo(Node.class) != null) {
            parentPath = this.removeTree(resource, this.filter);
        } else if (resource.adaptTo(Property.class) != null) {
            Property property = (Property)resource.adaptTo(Property.class);
            parentPath = property.getParent().getPath();
            logger.info("removing property {}", (Object)property.getPath());
            if (!this.isDryRun()) {
                property.remove();
            }
        }
        if (parentPath != null) {
            return Collections.singleton(this.resolver.getResource(parentPath)).iterator();
        }
        return Collections.emptyIterator();
    }

    private int removeProperties(Resource resource, Resource configuration) throws RepositoryException {
        int count = 0;
        if (configuration != null) {
            Node node = (Node)resource.adaptTo(Node.class);
            ValueMap configuredProperties = (ValueMap)configuration.adaptTo(ValueMap.class);
            for (String key : configuredProperties.keySet()) {
                if (IGNORED_PROPERTIES.contains(key)) continue;
                ++count;
                if (!node.hasProperty(key)) continue;
                logger.info("removing {}", (Object)node.getProperty(key).getPath());
                if (this.isDryRun()) continue;
                node.getProperty(key).remove();
            }
        }
        return count;
    }

    private String removeTree(Resource resource, Resource configuration) throws RepositoryException {
        NodeIterator childrenConfiguration;
        String remainingPath = resource.getPath();
        int configuredProperties = this.removeProperties(resource, configuration);
        Node configuredNode = configuration != null ? (Node)configuration.adaptTo(Node.class) : null;
        NodeIterator nodeIterator = childrenConfiguration = configuredNode != null ? configuredNode.getNodes() : null;
        if (childrenConfiguration == null || !childrenConfiguration.hasNext() && configuredProperties == 0) {
            logger.info("removing {}", (Object)resource.getPath());
            remainingPath = resource.getParent().getPath();
            if (!this.isDryRun()) {
                ((Node)resource.adaptTo(Node.class)).remove();
            }
        } else {
            while (childrenConfiguration.hasNext()) {
                Node childConf = childrenConfiguration.nextNode();
                Resource child = resource.getChild(childConf.getName());
                if (child == null) continue;
                this.removeTree(child, configuration.getChild(childConf.getName()));
            }
        }
        return remainingPath;
    }
}

