/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.ScriptException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackagingService;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagePipe
extends BasePipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackagePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/package";
    public static final String PN_FILTERCOLLECTIONMODE = "filterCollectionMode";
    public static final String PN_ASSEMBLE = "assemble";
    public static final String PN_CHECKEXISTENCE = "checkExistence";
    DefaultWorkspaceFilter filters;
    JcrPackage jcrPackage;
    boolean assemble;
    boolean checkExistence;

    public PackagePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
        this.assemble = (Boolean)this.properties.get(PN_ASSEMBLE, (Object)true);
        this.checkExistence = (Boolean)this.properties.get(PN_CHECKEXISTENCE, (Object)true);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        Resource filterResource;
        Iterator output = EMPTY_ITERATOR;
        this.init();
        if (((Boolean)this.properties.get(PN_FILTERCOLLECTIONMODE, (Object)false)).booleanValue() && ((filterResource = this.getInput()) != null || !this.checkExistence)) {
            if (this.filters == null) {
                this.filters = new DefaultWorkspaceFilter();
            }
            String filter = filterResource != null ? filterResource.getPath() : this.getComputedPath();
            this.filters.add(new PathFilterSet(filter));
            this.jcrPackage.getDefinition().setFilter((WorkspaceFilter)this.filters, true);
            output = IteratorUtils.singletonIterator((Object)this.getInput());
        }
        return output;
    }

    protected void init() throws IOException, RepositoryException, ScriptException {
        if (this.jcrPackage == null) {
            String packagePath = this.getExpr();
            if (StringUtils.isNotBlank((CharSequence)packagePath)) {
                JcrPackageManager mgr = PackagingService.getPackageManager((Session)((Session)this.resolver.adaptTo(Session.class)));
                Resource packageResource = this.resolver.getResource(packagePath);
                if (packageResource != null) {
                    this.jcrPackage = mgr.open((Node)packageResource.adaptTo(Node.class));
                } else {
                    String parent = Text.getRelativeParent((String)packagePath, (int)1);
                    Resource folderResource = this.resolver.getResource(parent);
                    if (folderResource == null) {
                        LOGGER.error("folder of configured path should exists");
                    } else {
                        String name = Text.getName((String)packagePath);
                        this.jcrPackage = mgr.create((Node)folderResource.adaptTo(Node.class), name);
                    }
                }
            } else {
                LOGGER.error("expression should not be blank as it's supposed to hold package path");
            }
        }
    }

    @Override
    public void after() throws Exception {
        super.after();
        if (this.assemble) {
            JcrPackageManager mgr = PackagingService.getPackageManager((Session)((Session)this.resolver.adaptTo(Session.class)));
            mgr.assemble(this.jcrPackage, null);
        }
    }
}

