/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamPipe
extends BasePipe {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamPipe.class);
    public final String REMOTE_START = "http";
    protected final Pattern VALID_PATH = Pattern.compile("/([\\w\\d\\.-_]+/)+[\\w\\d\\.-_]+");
    public static final Object BINDING_IS = "org.apache.sling.pipes.RequestInputStream";
    HttpClient client;
    protected Object binding;
    GetMethod method = null;
    InputStream is;

    public AbstractInputStreamPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
        this.configureHttpClient();
        this.binding = null;
    }

    private void configureHttpClient() {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        manager.setParams(params);
        this.client = new HttpClient((HttpConnectionManager)manager);
        this.client.getParams().setAuthenticationPreemptive(false);
    }

    InputStream getInputStream() throws Exception {
        String expr = this.getExpr();
        if (expr.startsWith("http")) {
            HttpState httpState = new HttpState();
            String url = this.getExpr();
            if (StringUtils.isNotBlank((CharSequence)url)) {
                this.method = new GetMethod(url);
                LOGGER.debug("Executing GET {}", (Object)url);
                int status = this.client.executeMethod(null, (HttpMethod)this.method, httpState);
                if (status == 200) {
                    LOGGER.debug("200 received, streaming content");
                    return this.method.getResponseBodyAsStream();
                }
            }
        } else {
            if (this.VALID_PATH.matcher(expr).find() && this.resolver.getResource(expr) != null && this.resolver.getResource(expr).adaptTo(InputStream.class) != null) {
                return (InputStream)this.resolver.getResource(expr).adaptTo(InputStream.class);
            }
            if (this.getBindings().getBindings().get(BINDING_IS) != null) {
                return (InputStream)this.getBindings().getBindings().get(BINDING_IS);
            }
        }
        return new ByteArrayInputStream(expr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Object getOutputBinding() {
        return this.binding;
    }

    public abstract Iterator<Resource> getOutput(InputStream var1) throws Exception;

    @Override
    public Iterator<Resource> computeOutput() throws Exception {
        try {
            this.is = this.getInputStream();
            Iterator<Resource> iterator = this.getOutput(this.is);
            return iterator;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.is);
            if (this.method != null) {
                this.method.releaseConnection();
            }
        }
    }
}

