/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.sling.jcr.repoinit.impl.AclUtil;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.apache.sling.repoinit.parser.operations.PathSegmentDefinition;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.apache.sling.repoinit.parser.operations.SetAclPaths;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipals;

class AclVisitor
extends DoNothingVisitor {
    public AclVisitor(Session s) {
        super(s);
    }

    private List<String> require(AclLine line, String propertyName) {
        List result = line.getProperty(propertyName);
        if (result == null) {
            throw new IllegalStateException("Missing property " + propertyName + " on " + line);
        }
        return result;
    }

    private void setAcl(AclLine line, Session s, List<String> principals, List<String> paths, List<String> privileges, boolean isAllow) {
        try {
            this.log.info("Adding ACL '{}' entry '{}' for {} on {}", new Object[]{isAllow ? "allow" : "deny", privileges, principals, paths});
            List restrictions = line.getRestrictions();
            AclUtil.setAcl(s, principals, paths, privileges, isAllow, (List<RestrictionClause>)restrictions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set ACL (" + e.toString() + ") " + line, e);
        }
    }

    private void setRepositoryAcl(AclLine line, Session s, List<String> principals, List<String> privileges, boolean isAllow) {
        try {
            this.log.info("Adding repository level ACL '{}' entry '{}' for {}", new Object[]{isAllow ? "allow" : "deny", privileges, principals});
            List restrictions = line.getRestrictions();
            AclUtil.setRepositoryAcl(s, principals, privileges, isAllow, restrictions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set repository level ACL (" + e.toString() + ") " + line, e);
        }
    }

    @Override
    public void visitSetAclPrincipal(SetAclPrincipals s) {
        List principals = s.getPrincipals();
        for (AclLine line : s.getLines()) {
            boolean isAllow = line.getAction().equals((Object)AclLine.Action.ALLOW);
            List paths = line.getProperty("paths");
            if (paths != null && !paths.isEmpty()) {
                this.setAcl(line, this.session, principals, paths, this.require(line, "privileges"), isAllow);
                continue;
            }
            this.setRepositoryAcl(line, this.session, principals, this.require(line, "privileges"), isAllow);
        }
    }

    @Override
    public void visitSetAclPaths(SetAclPaths s) {
        List paths = s.getPaths();
        for (AclLine line : s.getLines()) {
            boolean isAllow = line.getAction().equals((Object)AclLine.Action.ALLOW);
            this.setAcl(line, this.session, this.require(line, "principals"), paths, this.require(line, "privileges"), isAllow);
        }
    }

    @Override
    public void visitSetAclPrincipalBased(SetAclPrincipalBased s) {
        for (String principalName : s.getPrincipals()) {
            try {
                this.log.info("Adding principal-based access control entry for {}", (Object)principalName);
                AclUtil.setPrincipalAcl(this.session, principalName, s.getLines());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set principal-based ACL (" + e.getMessage() + ")", e);
            }
        }
    }

    @Override
    public void visitCreatePath(CreatePath cp) {
        String parentPath = "";
        for (PathSegmentDefinition psd : cp.getDefinitions()) {
            String fullPath = parentPath + "/" + psd.getSegment();
            try {
                if (this.session.itemExists(fullPath)) {
                    this.log.info("Path already exists, nothing to do (and not checking its primary type for now): {}", (Object)fullPath);
                } else {
                    Node parent = parentPath.equals("") ? this.session.getRootNode() : this.session.getNode(parentPath);
                    this.log.info("Creating node {} with primary type {}", (Object)fullPath, (Object)psd.getPrimaryType());
                    Node node = parent.addNode(psd.getSegment(), psd.getPrimaryType());
                    List mixins = psd.getMixins();
                    if (mixins != null) {
                        this.log.info("Adding mixins {} to node {}", (Object)mixins, (Object)fullPath);
                        for (String mixin : mixins) {
                            node.addMixin(mixin);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("CreatePath execution failed at " + psd + ": " + e, e);
            }
            parentPath = parentPath + "/" + psd.getSegment();
        }
        try {
            this.session.save();
        }
        catch (Exception e) {
            throw new RuntimeException("Session.save failed: " + e, e);
        }
    }
}

