/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.json.JsonObject;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetPrincipalAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrincipalAceHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractGetAceServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, GetPrincipalAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=pace", "sling.servlet.selectors=tidy.pace", "sling.servlet.extensions=json", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="RestrictionProvider", bind="bindRestrictionProvider", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=RestrictionProvider.class)})
public class GetPrincipalAceServlet
extends AbstractGetAceServlet
implements GetPrincipalAce {
    private static final long serialVersionUID = 1654062732084983394L;

    @Override
    @Nullable
    protected String getItemPath(SlingHttpServletRequest request) {
        return PrincipalAceHelper.getEffectivePath(request);
    }

    @Override
    protected void validateResourcePath(Session jcrSession, String resourcePath) throws RepositoryException {
    }

    @Override
    public JsonObject getPrincipalAce(Session jcrSession, String resourcePath, String principalId) throws RepositoryException {
        return this.internalGetAce(jcrSession, resourcePath, principalId);
    }

    @Override
    protected Map<String, List<AccessControlEntry>> getAccessControlEntriesMap(Session session, String absPath, Principal principal, Map<Principal, Map<DeclarationType, Set<String>>> declaredAtPaths) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        if (acMgr instanceof JackrabbitAccessControlManager) {
            JackrabbitAccessControlManager jacMgr = (JackrabbitAccessControlManager)acMgr;
            JackrabbitAccessControlPolicy[] policies = jacMgr.getPolicies(principal);
            return this.entriesSortedByEffectivePath((AccessControlPolicy[])policies, ace -> this.matchesPrincipalAccessControlEntry((AccessControlEntry)ace, absPath, principal), declaredAtPaths);
        }
        return Collections.emptyMap();
    }

    protected boolean matchesPrincipalAccessControlEntry(@NotNull AccessControlEntry entry, @NotNull String resourcePath, @NotNull Principal forPrincipal) {
        JackrabbitAccessControlEntry jrEntry = null;
        if (entry instanceof PrincipalAccessControlList.Entry && entry.getPrincipal().equals(forPrincipal) && PrincipalAceHelper.matchesResourcePath(resourcePath, entry)) {
            jrEntry = (JackrabbitAccessControlEntry)entry;
        }
        return jrEntry != null;
    }
}

