/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.json.JsonObject;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.Servlet;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.jcr.jackrabbit.accessmanager.GetAce;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractGetAceServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, GetAce.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=ace", "sling.servlet.selectors=tidy.ace", "sling.servlet.extensions=json", "sling.servlet.prefix:Integer=-1"}, reference={@Reference(name="RestrictionProvider", bind="bindRestrictionProvider", cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, service=RestrictionProvider.class)})
public class GetAceServlet
extends AbstractGetAceServlet
implements GetAce {
    private static final long serialVersionUID = 1654062732084983394L;

    @Override
    public JsonObject getAce(Session jcrSession, String resourcePath, String principalId) throws RepositoryException {
        return this.internalGetAce(jcrSession, resourcePath, principalId);
    }

    @Override
    protected Map<String, List<AccessControlEntry>> getAccessControlEntriesMap(Session session, String absPath, Principal principal, Map<Principal, Map<DeclarationType, Set<String>>> declaredAtPaths) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlPolicy[] policies = acMgr.getPolicies(absPath);
        return this.entriesSortedByEffectivePath(policies, ace -> principal.equals(ace.getPrincipal()), declaredAtPaths);
    }
}

