/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.jcr.contentloader.internal.ContentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContentCreator
implements ContentCreator {
    final Logger log = LoggerFactory.getLogger(DefaultContentCreator.class);
    private ImportOptions configuration;
    private final Pattern jsonDatePattern = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");
    private final SimpleDateFormat jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final Stack<Node> parentNodeStack = new Stack();
    private final List<Node> versionables = new ArrayList<Node>();
    private final Map<String, List<String>> delayedReferences = new HashMap<String, List<String>>();
    private final Map<String, String[]> delayedMultipleReferences = new HashMap<String, String[]>();
    private String defaultName;
    private Node createdRootNode;
    private boolean isParentNodeImport;
    private boolean ignoreOverwriteFlag = false;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final ContentHelper contentHelper;
    private Map<String, ContentReader> contentReaders;
    private List<String> createdNodes;
    private ContentImportListener importListener;
    private static final long INSTANCE_SEED = System.currentTimeMillis();
    private static final int STORAGE_LEVELS = 3;
    private static final char[] hexTable = "0123456789abcdef".toCharArray();

    public DefaultContentCreator(ContentHelper contentHelper) {
        this.contentHelper = contentHelper;
    }

    public void init(ImportOptions pathEntry, Map<String, ContentReader> defaultContentReaders, List<String> createdNodes, ContentImportListener importListener) {
        this.configuration = pathEntry;
        this.contentReaders = new HashMap<String, ContentReader>();
        for (Map.Entry<String, ContentReader> current : defaultContentReaders.entrySet()) {
            if (this.configuration.isIgnoredImportProvider(current.getKey())) continue;
            this.contentReaders.put(current.getKey(), current.getValue());
        }
        this.createdNodes = createdNodes;
        this.importListener = importListener;
    }

    public void prepareParsing(Node parentNode, String defaultName) {
        this.parentNodeStack.clear();
        this.parentNodeStack.push(parentNode);
        this.defaultName = defaultName;
        this.isParentNodeImport = defaultName == null;
        this.createdRootNode = null;
    }

    public List<Node> getVersionables() {
        return this.versionables;
    }

    public void clear() {
        this.versionables.clear();
    }

    public void setIgnoreOverwriteFlag(boolean flag) {
        this.ignoreOverwriteFlag = flag;
    }

    public Node getCreatedRootNode() {
        return this.createdRootNode;
    }

    public Map<String, ContentReader> getContentReaders() {
        return this.contentReaders;
    }

    @Override
    public void createNode(String name, String primaryNodeType, String[] mixinNodeTypes) throws RepositoryException {
        boolean isParentImport;
        Node parentNode = this.parentNodeStack.peek();
        boolean bl = isParentImport = name == null && this.isParentNodeImport;
        if (name == null) {
            if (this.parentNodeStack.size() > 1) {
                throw new RepositoryException("Node needs to have a name.");
            }
            name = this.defaultName;
        }
        if (!isParentImport || this.parentNodeStack.size() > 1) {
            boolean addToVersionables;
            Node node;
            if (!this.ignoreOverwriteFlag && this.configuration.isOverwrite() && parentNode.hasNode(name)) {
                this.checkoutIfNecessary(parentNode);
                parentNode.getNode(name).remove();
            }
            if (parentNode.hasNode(name)) {
                node = parentNode.getNode(name);
            } else if (primaryNodeType == null) {
                this.checkoutIfNecessary(parentNode);
                node = parentNode.addNode(name);
                this.addNodeToCreatedList(node);
                if (this.importListener != null) {
                    this.importListener.onCreate(node.getPath());
                }
            } else {
                this.checkoutIfNecessary(parentNode);
                node = parentNode.addNode(name, primaryNodeType);
                this.addNodeToCreatedList(node);
                if (this.importListener != null) {
                    this.importListener.onCreate(node.getPath());
                }
            }
            if (mixinNodeTypes != null) {
                for (String mixin : mixinNodeTypes) {
                    if (node.isNodeType(mixin)) continue;
                    node.addMixin(mixin);
                }
            }
            boolean bl2 = addToVersionables = this.configuration.isCheckin() && node.isNodeType("mix:versionable");
            if (addToVersionables) {
                this.versionables.add(node);
            }
            this.parentNodeStack.push(node);
            if (this.createdRootNode == null) {
                this.createdRootNode = node;
            }
        }
    }

    @Override
    public void createProperty(String name, int propertyType, String value) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !this.configuration.isPropertyOverwrite() && !node.getProperty(name).isNew()) {
            return;
        }
        if (propertyType == 9) {
            String propPath = node.getPath() + "/" + name;
            String uuid = this.getUUID(node.getSession(), propPath, this.getAbsPath(node, value));
            if (uuid != null) {
                this.checkoutIfNecessary(node);
                node.setProperty(name, uuid, propertyType);
                if (this.importListener != null) {
                    this.importListener.onCreate(node.getProperty(name).getPath());
                }
            }
        } else if ("jcr:isCheckedOut".equals(name)) {
            boolean checkedout = Boolean.valueOf(value);
            if (!checkedout && !this.versionables.contains(node)) {
                this.versionables.add(node);
            }
        } else if (propertyType == 5) {
            this.checkoutIfNecessary(node);
            try {
                node.setProperty(name, this.parseDateString(value));
            }
            catch (ParseException e) {
                node.setProperty(name, value, propertyType);
            }
            if (this.importListener != null) {
                this.importListener.onCreate(node.getProperty(name).getPath());
            }
        } else {
            this.checkoutIfNecessary(node);
            if (propertyType == 0) {
                node.setProperty(name, value);
            } else {
                node.setProperty(name, value, propertyType);
            }
            if (this.importListener != null) {
                this.importListener.onCreate(node.getProperty(name).getPath());
            }
        }
    }

    @Override
    public void createProperty(String name, int propertyType, String[] values) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !this.configuration.isPropertyOverwrite() && !node.getProperty(name).isNew()) {
            return;
        }
        if (propertyType == 9) {
            String propPath = node.getPath() + "/" + name;
            boolean hasAll = true;
            String[] uuids = new String[values.length];
            String[] uuidOrPaths = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                uuids[i] = this.getUUID(node.getSession(), propPath, this.getAbsPath(node, values[i]));
                String string = uuidOrPaths[i] = uuids[i] != null ? uuids[i] : this.getAbsPath(node, values[i]);
                if (uuids[i] != null) continue;
                hasAll = false;
            }
            this.checkoutIfNecessary(node);
            node.setProperty(name, uuids, propertyType);
            if (this.importListener != null) {
                this.importListener.onCreate(node.getProperty(name).getPath());
            }
            if (!hasAll) {
                this.delayedMultipleReferences.put(propPath, uuidOrPaths);
            }
        } else if (propertyType == 5) {
            this.checkoutIfNecessary(node);
            try {
                ValueFactory valueFactory = node.getSession().getValueFactory();
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = valueFactory.createValue(this.parseDateString(values[i]));
                }
                node.setProperty(name, jcrValues, propertyType);
            }
            catch (ParseException e) {
                this.log.warn("Could not create dates for property, falling back to defaults", (Throwable)e);
                node.setProperty(name, values, propertyType);
            }
            if (this.importListener != null) {
                this.importListener.onCreate(node.getProperty(name).getPath());
            }
        } else {
            this.checkoutIfNecessary(node);
            if (propertyType == 0) {
                node.setProperty(name, values);
            } else {
                node.setProperty(name, values, propertyType);
            }
            if (this.importListener != null) {
                this.importListener.onCreate(node.getProperty(name).getPath());
            }
        }
    }

    protected Value createValue(ValueFactory factory, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return factory.createValue(((Long)value).longValue());
        }
        if (value instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)value);
            return factory.createValue(c);
        }
        if (value instanceof Calendar) {
            return factory.createValue((Calendar)value);
        }
        if (value instanceof Double) {
            return factory.createValue(((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return factory.createValue(((Boolean)value).booleanValue());
        }
        if (value instanceof InputStream) {
            return factory.createValue((InputStream)value);
        }
        return factory.createValue(value.toString());
    }

    @Override
    public void createProperty(String name, Object value) throws RepositoryException {
        this.createProperty(name, value, false);
    }

    @Override
    public void createProperty(String name, Object[] values) throws RepositoryException {
        this.createProperty(name, values, false);
    }

    @Override
    public void finishNode() throws RepositoryException {
        Node node = this.parentNodeStack.pop();
        this.resolveReferences(node);
    }

    private void addNodeToCreatedList(Node node) throws RepositoryException {
        if (this.createdNodes != null) {
            this.createdNodes.add(node.getSession().getWorkspace().getName() + ":" + node.getPath());
        }
    }

    private String getAbsPath(Node node, String path) throws RepositoryException {
        if (path.startsWith("/")) {
            return path;
        }
        while (path.startsWith("../")) {
            path = path.substring(3);
            node = node.getParent();
        }
        while (path.startsWith("./")) {
            path = path.substring(2);
        }
        return node.getPath() + "/" + path;
    }

    private String getUUID(Session session, String propPath, String referencePath) throws RepositoryException {
        if (session.itemExists(referencePath)) {
            Node refNode;
            Item item = session.getItem(referencePath);
            if (item.isNode() && (refNode = (Node)item).isNodeType("mix:referenceable")) {
                return refNode.getUUID();
            }
        } else {
            List<String> current = this.delayedReferences.get(referencePath);
            if (current == null) {
                current = new ArrayList<String>();
                this.delayedReferences.put(referencePath, current);
            }
            current.add(propPath);
        }
        return null;
    }

    private void resolveReferences(Node node) throws RepositoryException {
        List<String> props = this.delayedReferences.remove(node.getPath());
        if (props == null || props.size() == 0) {
            return;
        }
        if (!node.isNodeType("mix:referenceable")) {
            return;
        }
        Session session = node.getSession();
        String uuid = node.getUUID();
        for (String property : props) {
            String name = this.getName(property);
            Node parentNode = this.getParentNode(session, property);
            if (parentNode == null) continue;
            this.checkoutIfNecessary(parentNode);
            if (parentNode.hasProperty(name) && parentNode.getProperty(name).getDefinition().isMultiple()) {
                boolean hasAll = true;
                String[] uuidOrPaths = this.delayedMultipleReferences.get(property);
                String[] uuids = new String[uuidOrPaths.length];
                for (int i = 0; i < uuidOrPaths.length; ++i) {
                    if (uuidOrPaths[i].startsWith("/")) {
                        if (uuidOrPaths[i].equals(node.getPath())) {
                            uuidOrPaths[i] = uuid;
                            uuids[i] = uuid;
                            continue;
                        }
                        uuids[i] = null;
                        hasAll = false;
                        continue;
                    }
                    uuids[i] = uuidOrPaths[i];
                }
                parentNode.setProperty(name, uuids, 9);
                if (this.importListener != null) {
                    this.importListener.onCreate(parentNode.getProperty(name).getPath());
                }
                if (!hasAll) continue;
                this.delayedMultipleReferences.remove(property);
                continue;
            }
            parentNode.setProperty(name, uuid, 9);
            if (this.importListener == null) continue;
            this.importListener.onCreate(parentNode.getProperty(name).getPath());
        }
    }

    private String getName(String path) {
        int lastSlash = path.lastIndexOf(47);
        String name = lastSlash < 0 ? path : path.substring(lastSlash + 1);
        return name;
    }

    private Node getParentNode(Session session, String path) throws RepositoryException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            return session.getRootNode();
        }
        if (!session.itemExists(path = path.substring(0, lastSlash))) {
            return null;
        }
        Item item = session.getItem(path);
        return item.isNode() ? (Node)item : null;
    }

    private Calendar parseDateString(String value) throws ParseException {
        if (this.jsonDatePattern.matcher(value).matches()) {
            String modifiedJsonDate = value;
            if (value.lastIndexOf(":") == 26) {
                modifiedJsonDate = value.substring(0, 26) + value.substring(27);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.jsonDateFormat.parse(modifiedJsonDate));
            return cal;
        }
        return null;
    }

    private void createProperty(String name, Object value, boolean overwriteExisting) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew() && !overwriteExisting) {
            return;
        }
        if (value == null) {
            if (node.hasProperty(name)) {
                this.checkoutIfNecessary(node);
                String propPath = node.getProperty(name).getPath();
                node.getProperty(name).remove();
                if (this.importListener != null) {
                    this.importListener.onDelete(propPath);
                }
            }
        } else {
            this.checkoutIfNecessary(node);
            Value jcrValue = this.createValue(node.getSession().getValueFactory(), value);
            node.setProperty(name, jcrValue);
            if (this.importListener != null) {
                this.importListener.onModify(node.getProperty(name).getPath());
            }
        }
    }

    private void createProperty(String name, Object[] values, boolean overwriteExisting) throws RepositoryException {
        Node node = this.parentNodeStack.peek();
        if (node.hasProperty(name) && !node.getProperty(name).isNew() && !overwriteExisting) {
            return;
        }
        if (values == null || values.length == 0) {
            if (node.hasProperty(name)) {
                this.checkoutIfNecessary(node);
                String propPath = node.getProperty(name).getPath();
                node.getProperty(name).remove();
                if (this.importListener != null) {
                    this.importListener.onDelete(propPath);
                }
            }
        } else {
            this.checkoutIfNecessary(node);
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                jcrValues[i] = this.createValue(node.getSession().getValueFactory(), values[i]);
            }
            node.setProperty(name, jcrValues);
            if (this.importListener != null) {
                this.importListener.onModify(node.getProperty(name).getPath());
            }
        }
    }

    @Override
    public void createFileAndResourceNode(String name, InputStream data, String mimeType, long lastModified) throws RepositoryException {
        int lastSlash = name.lastIndexOf(47);
        name = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        Node parentNode = this.parentNodeStack.peek();
        if (parentNode.hasNode(name)) {
            this.parentNodeStack.push(parentNode.getNode(name));
            Node contentNode = parentNode.getNode(name).getNode("jcr:content");
            this.parentNodeStack.push(contentNode);
            long nodeLastModified = 0L;
            if (contentNode.hasProperty("jcr:lastModified")) {
                nodeLastModified = contentNode.getProperty("jcr:lastModified").getDate().getTimeInMillis();
            }
            if (!this.configuration.isOverwrite() && nodeLastModified >= lastModified) {
                return;
            }
            this.log.info("Updating {} lastModified:{} New Content LastModified:{}", new Object[]{parentNode.getNode(name).getPath(), new Date(nodeLastModified), new Date(lastModified)});
        } else {
            this.createNode(name, "nt:file", null);
            this.createNode("jcr:content", "nt:resource", null);
        }
        if (mimeType == null && (mimeType = this.contentHelper.getMimeType(name)) == null) {
            this.log.info("createFile: Cannot find content type for {}, using {}", (Object)name, (Object)DEFAULT_CONTENT_TYPE);
            mimeType = DEFAULT_CONTENT_TYPE;
        }
        if (lastModified <= 0L) {
            lastModified = System.currentTimeMillis();
        }
        this.createProperty("jcr:mimeType", mimeType, true);
        this.createProperty("jcr:lastModified", lastModified, true);
        this.createProperty("jcr:data", data, true);
    }

    @Override
    public boolean switchCurrentNode(String subPath, String newNodeType) throws RepositoryException {
        if (subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(subPath, "/");
        Node node = this.parentNodeStack.peek();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!node.hasNode(token)) {
                if (newNodeType == null) {
                    return false;
                }
                this.checkoutIfNecessary(node);
                Node n = node.addNode(token, newNodeType);
                this.addNodeToCreatedList(n);
                if (this.importListener != null) {
                    this.importListener.onCreate(node.getPath());
                }
            }
            node = node.getNode(token);
        }
        this.parentNodeStack.push(node);
        return true;
    }

    @Override
    public void createGroup(final String name, String[] members, Map<String, Object> extraProperties) throws RepositoryException {
        Group group;
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (authorizable == null) {
            group = userManager.createGroup(new Principal(){

                @Override
                public String getName() {
                    return name;
                }
            }, this.hashPath(name));
            authorizable = group;
        } else if (!authorizable.isGroup()) {
            throw new RepositoryException("A user already exists with the requested name: " + name);
        }
        if (members != null) {
            group = (Group)authorizable;
            for (String member : members) {
                Authorizable memberAuthorizable = userManager.getAuthorizable(member);
                if (memberAuthorizable == null) continue;
                group.addMember(memberAuthorizable);
            }
        }
        if (extraProperties != null) {
            ValueFactory valueFactory = session.getValueFactory();
            Set<Map.Entry<String, Object>> entrySet = extraProperties.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Value value = this.createValue(valueFactory, entry.getValue());
                authorizable.setProperty(entry.getKey(), value);
            }
        }
    }

    @Override
    public void createUser(final String name, String password, Map<String, Object> extraProperties) throws RepositoryException {
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (authorizable == null) {
            User user = userManager.createUser(name, password, new Principal(){

                @Override
                public String getName() {
                    return name;
                }
            }, this.hashPath(name));
            authorizable = user;
        } else if (authorizable.isGroup()) {
            throw new RepositoryException("A group already exists with the requested name: " + name);
        }
        if (extraProperties != null) {
            ValueFactory valueFactory = session.getValueFactory();
            Set<Map.Entry<String, Object>> entrySet = extraProperties.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Value value = this.createValue(valueFactory, entry.getValue());
                authorizable.setProperty(entry.getKey(), value);
            }
        }
    }

    protected String hashPath(String item) throws RepositoryException {
        try {
            String hash = DefaultContentCreator.digest("sha1", (INSTANCE_SEED + item).getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sb.append(hash, i * 2, i * 2 + 2).append("/");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RepositoryException("Unable to hash the path.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Unable to hash the path.", (Throwable)e);
        }
    }

    @Override
    public void createAce(String principalId, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String order) throws RepositoryException {
        Node parentNode = this.parentNodeStack.peek();
        Session session = parentNode.getSession();
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
        Principal principal = principalManager.getPrincipal(principalId);
        if (principal == null) {
            throw new RepositoryException("No principal found for id: " + principalId);
        }
        String resourcePath = parentNode.getPath();
        if (grantedPrivilegeNames != null || deniedPrivilegeNames != null) {
            AccessControlUtil.replaceAccessControlEntry((Session)session, (String)resourcePath, (Principal)principal, (String[])grantedPrivilegeNames, (String[])deniedPrivilegeNames, null, (String)order);
        }
    }

    public static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(data);
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }

    protected Node findVersionableAncestor(Node node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        if (this.isVersionable(node)) {
            return node;
        }
        try {
            node = node.getParent();
            return this.findVersionableAncestor(node);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    protected boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    protected void checkoutIfNecessary(Node node) throws RepositoryException {
        Node versionableNode;
        if (this.configuration.isAutoCheckout() && (versionableNode = this.findVersionableAncestor(node)) != null && !versionableNode.isCheckedOut()) {
            versionableNode.checkout();
            if (this.importListener != null) {
                this.importListener.onCheckout(versionableNode.getPath());
            }
        }
    }
}

